/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);
    public static final String TMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    private static final int BUFFER_SIZE = 100000;
    private static final String CLASS_EXT = ".class";

    private IOUtil() {
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return IOUtil.generateJar(IOUtil.getResources(classes));
    }

    public static byte[] generateJar(String className, String ... content) throws IOException {
        return IOUtil.generateJar(Collections.emptyList(), new AbstractMap.SimpleEntry<String, String>(className, String.join((CharSequence)"\n", content)));
    }

    public static byte[] generateJar(Map.Entry<String, String> ... classFiles) throws IOException {
        return IOUtil.generateJar(Collections.emptyList(), classFiles);
    }

    public static byte[] generateJar(List<Path> additionalJar, String className, String ... content) throws IOException {
        return IOUtil.generateJar(additionalJar, new AbstractMap.SimpleEntry<String, String>(className, String.join((CharSequence)"\n", content)));
    }

    public static byte[] generateJar(List<Path> additionalJar, Map.Entry<String, String> ... classFiles) throws IOException {
        List sourceFiles = Arrays.stream(classFiles).map(classFile -> {
            StringJavaFileObject sourceFile = new StringJavaFileObject((String)classFile.getKey(), (String)classFile.getValue());
            return sourceFile;
        }).collect(Collectors.toList());
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(null, null, null);
        IOUtil.updateClassPath(additionalJar, standardFileManager);
        standardFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(Files.createTempDirectory("compile-test", new FileAttribute[0]).toFile()));
        JavaCompiler.CompilationTask run = compiler.getTask(null, standardFileManager, null, null, null, sourceFiles);
        Boolean call = run.call();
        if (!call.booleanValue()) {
            throw new IllegalArgumentException("Unable to compile the file, see logs");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Map.Entry<String, String> classFile2 : classFiles) {
            String className = classFile2.getKey();
            JavaFileObject javaFileForInput = standardFileManager.getJavaFileForInput(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS);
            byte[] bytes = Files.readAllBytes(Paths.get(javaFileForInput.toUri()));
            resources.put(className.replace(".", "/") + CLASS_EXT, bytes);
        }
        return IOUtil.generateJar(resources);
    }

    private static void updateClassPath(List<Path> additionalJar, StandardJavaFileManager standardFileManager) throws IOException {
        Iterable<? extends File> location = standardFileManager.getLocation(StandardLocation.CLASS_PATH);
        ArrayList classPath = new ArrayList();
        location.forEach(classPath::add);
        additionalJar.stream().map(Path::toFile).forEach(classPath::add);
        standardFileManager.setLocation(StandardLocation.CLASS_PATH, classPath);
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = "No classes available";
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + CLASS_EXT, IOUtil.getClassData(clazz));
            for (Class<?> internalClass : clazz.getDeclaredClasses()) {
                resources.put(internalClass.getName().replace(".", "/") + CLASS_EXT, IOUtil.getClassData(internalClass));
            }
        }
        return resources;
    }

    public static byte[] getClassData(Class<?> clazz) throws IOException {
        byte[] data;
        if (clazz == null) {
            String message = "Class is null";
            throw new IOException("Class is null");
        }
        String resource = clazz.getName().replace('.', '/') + CLASS_EXT;
        try (InputStream inputStream = clazz.getClassLoader().getResourceAsStream(resource);){
            if (inputStream == null) {
                throw new IOException("Impossible to get stream from class: " + clazz.getName() + ", className= " + resource);
            }
            data = IOUtil.getAllContentFrom(inputStream);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.isEmpty()) {
            String message = "No resources available";
            throw new IOException("No resources available");
        }
        ByteArrayOutputStream baos = null;
        ZipOutputStream jarOutStream = null;
        try {
            baos = new ByteArrayOutputStream();
            jarOutStream = new JarOutputStream(new BufferedOutputStream(baos));
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                ((JarOutputStream)jarOutStream).putNextEntry(new JarEntry(resource.getKey()));
                jarOutStream.write(resource.getValue());
            }
            jarOutStream.flush();
            baos.flush();
        }
        finally {
            if (jarOutStream != null) {
                jarOutStream.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        byte[] resultArray;
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        byte[] buffer = new byte[100000];
        try (BufferedInputStream bis = new BufferedInputStream(in);
             ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int amountRead;
            while ((amountRead = bis.read(buffer)) > 0) {
                result.write(buffer, 0, amountRead);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        return resultArray;
    }

    public static byte[] getAllContentFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
    }

    public static byte[] getAllContentFrom(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            byte[] byArray = IOUtil.getAllContentFrom(in);
            return byArray;
        }
    }

    public static File createTempDirectory(URI directoryPath) {
        File tmpDir = new File(directoryPath);
        tmpDir.setReadable(true);
        tmpDir.setWritable(true);
        IOUtil.mkdirs(tmpDir);
        Files.isSymbolicLink(tmpDir.toPath());
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    boolean deleted = IOUtil.deleteDir(tmpDir);
                    if (!deleted) {
                        String errorMsg = "Unable to delete directory: " + String.valueOf(tmpDir);
                        log.error(errorMsg);
                        if (!tmpDir.exists()) {
                            throw new FileNotFoundException("Directory does not exist: " + String.valueOf(tmpDir));
                        }
                        throw new IOException(errorMsg);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return tmpDir;
    }

    public static boolean deleteDir(File dir) throws IOException {
        return IOUtil.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) throws IOException {
        if (dir != null) {
            boolean result = true;
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                throw new IOException("Unable to delete directory: " + String.valueOf(dir) + ", it is not a directory");
            }
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    result &= IOUtil.deleteDir(file, attempts, sleepTime);
                    continue;
                }
                result &= IOUtil.deleteFile(file, attempts, sleepTime);
            }
            return result && IOUtil.deleteFile(dir, attempts, sleepTime);
        }
        return false;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return retries > 0;
    }

    public static byte[] zip(Map<String, byte[]> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                zos.putNextEntry(new ZipEntry(file.getKey()));
                zos.write(file.getValue());
                zos.closeEntry();
            }
            Object object = baos.toByteArray();
            return object;
        }
    }

    public static void unzipToFolder(InputStream inputStream, File outputFolder) throws IOException {
        try (ZipInputStream zipInputstream = new ZipInputStream(inputStream);){
            IOUtil.extractZipEntries(zipInputstream, outputFolder);
        }
    }

    private static void mkdirs(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipEntries(ZipInputStream zipInputstream, File outputFolder) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputstream.getNextEntry()) != null) {
            try {
                File outputFile = new File(outputFolder.getAbsolutePath(), zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    IOUtil.mkdirs(outputFile);
                    continue;
                }
                IOUtil.writeZipInputToFile(zipInputstream, outputFile);
            }
            finally {
                zipInputstream.closeEntry();
            }
        }
    }

    private static void writeZipInputToFile(ZipInputStream zipInputstream, File outputFile) throws FileNotFoundException, IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.flush();
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
    }

    public static void writeContentToFile(String content, File outputFile) throws IOException {
        FileOutputStream fileOutput = new FileOutputStream(outputFile);
        IOUtil.writeContentToFileOutputStream(content, fileOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFileOutputStream(String content, FileOutputStream fileOutput) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOutput, StandardCharsets.UTF_8);){
            out.write(content);
            out.flush();
        }
        finally {
            fileOutput.close();
        }
    }

    public static void write(File file, byte[] fileContent) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(fileContent);
            bos.flush();
        }
    }

    public static byte[] getContent(File file) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            byte[] byArray;
            block11: {
                FileChannel ch = fin.getChannel();
                try {
                    int size = (int)ch.size();
                    MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    byte[] bytes = new byte[size];
                    buf.get(bytes);
                    byArray = bytes;
                    if (ch == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return byArray;
        }
    }

    static class StringJavaFileObject
    extends SimpleJavaFileObject {
        private final String sourceCode;

        StringJavaFileObject(String className, String content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = content;
        }

        @Override
        public CharSequence getCharContent(boolean var1) {
            return this.sourceCode;
        }
    }
}

