/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllConfigurationResourceVisitor
extends SimpleFileVisitor<Path> {
    private final List<FullBonitaConfiguration> fullBonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(AllConfigurationResourceVisitor.class);
    private static final List<String> CONFIGURATION_FOLDERS = Arrays.asList(ConfigurationType.PLATFORM_PORTAL.name().toLowerCase(), ConfigurationType.PLATFORM_ENGINE.name().toLowerCase(), ConfigurationType.TENANT_PORTAL.name().toLowerCase(), ConfigurationType.TENANT_ENGINE.name().toLowerCase(), ConfigurationType.TENANT_SECURITY_SCRIPTS.name().toLowerCase());

    public AllConfigurationResourceVisitor(List<FullBonitaConfiguration> fullBonitaConfigurations) {
        this.fullBonitaConfigurations = fullBonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    private String getFolderName(Path dir) {
        return dir.getFileName().toString().toUpperCase();
    }

    private boolean isConfigurationFolder(Path dir) {
        return CONFIGURATION_FOLDERS.contains(dir.getFileName().toString());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.isConfigurationFile(path)) {
            String configurationType = this.getFolderName(path.getParent());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("found file: {}/{}", (Object)configurationType.toLowerCase(), (Object)path.getFileName());
            }
            this.fullBonitaConfigurations.add(new FullBonitaConfiguration(path.getFileName().toString(), Files.readAllBytes(path), configurationType));
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean isConfigurationFile(Path path) {
        return path.toFile().isFile() && this.isConfigurationFolder(path.getParent());
    }
}

