/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateConfigurationVisitor
extends SimpleFileVisitor<Path> {
    private final List<BonitaConfiguration> bonitaConfigurations;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoUpdateConfigurationVisitor.class);
    private static final List<String> AUTO_UPDATE_CONFIGURATION_FILES = Arrays.asList("compound-permissions-mapping.properties", "dynamic-permissions-checks.properties", "resources-permissions-mapping.properties", "user-creation-attribute-mapping.properties");

    public AutoUpdateConfigurationVisitor(List<BonitaConfiguration> bonitaConfigurations) {
        this.bonitaConfigurations = bonitaConfigurations;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) {
        return FileVisitResult.CONTINUE;
    }

    private String getFolderName(Path dir) {
        return dir.getFileName().toString().toUpperCase();
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.isAutoUpdateConfigurationFile(path)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.buildMessage(path, this.getFolderName(path.getParent())));
            }
            this.bonitaConfigurations.add(new BonitaConfiguration(path.getFileName().toString(), Files.readAllBytes(path)));
        }
        return FileVisitResult.CONTINUE;
    }

    private String buildMessage(Path path, String configurationType) {
        return "found file: " + configurationType.toLowerCase() + "/" + String.valueOf(path.getFileName());
    }

    boolean isAutoUpdateConfigurationFile(Path path) {
        return path.toFile().isFile() && AUTO_UPDATE_CONFIGURATION_FILES.contains(path.getFileName().toString());
    }
}

