/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.model.LightBonitaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class GetMandatoryStructureConfiguration
implements TransactionCallback<List<LightBonitaConfiguration>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetMandatoryStructureConfiguration.class);
    private final JdbcTemplate jdbcTemplate;

    public GetMandatoryStructureConfiguration(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<LightBonitaConfiguration> doInTransaction(TransactionStatus transactionStatus) {
        List lightBonitaConfigurations = this.jdbcTemplate.query("SELECT distinct content_type FROM configuration WHERE content_type <> 'LICENSES' ORDER BY content_type", (RowMapper)new LightBonitaConfigurationRowMapper());
        LOGGER.debug("configurations found:{}", (Object)lightBonitaConfigurations);
        return lightBonitaConfigurations;
    }

    class LightBonitaConfigurationRowMapper
    implements RowMapper<LightBonitaConfiguration> {
        public static final String SELECT = "SELECT distinct content_type FROM configuration WHERE content_type <> 'LICENSES' ORDER BY content_type";

        LightBonitaConfigurationRowMapper() {
        }

        public LightBonitaConfiguration mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new LightBonitaConfiguration(rs.getString("content_type"));
        }
    }
}

