/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationPreparedStatementCleaner;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationPreparedStatementSetter;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class StoreConfigurationInTransaction
extends TransactionCallbackWithoutResult {
    private final JdbcTemplate jdbcTemplate;
    private final List<BonitaConfiguration> bonitaConfigurations;
    private final ConfigurationType type;
    private final String dbVendor;
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreConfigurationInTransaction.class);

    public StoreConfigurationInTransaction(JdbcTemplate jdbcTemplate, String dbVendor, List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbVendor = dbVendor;
        this.bonitaConfigurations = bonitaConfigurations;
        this.type = type;
    }

    protected void doInTransactionWithoutResult(TransactionStatus status) {
        LOGGER.debug("delete configurations for type:{} bonitaConfigurations:{}", (Object)this.type.name(), this.bonitaConfigurations);
        this.jdbcTemplate.batchUpdate("DELETE from configuration where content_type = ? and resource_name = ?", (BatchPreparedStatementSetter)new BonitaConfigurationPreparedStatementCleaner(this.bonitaConfigurations, this.type));
        LOGGER.debug("store configurations for type:{} bonitaConfigurations:{}", (Object)this.type.name(), this.bonitaConfigurations);
        this.jdbcTemplate.batchUpdate("INSERT into configuration(content_type, resource_name, resource_content) values (?,?,?)", (BatchPreparedStatementSetter)new BonitaConfigurationPreparedStatementSetter(this.bonitaConfigurations, this.dbVendor, this.type));
    }
}

