/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class SimpleEncryptor {
    private static final byte[] SALT = new byte[]{71, 111, 111, 100, 74, 111, 98, 33};
    private static final char[] PASSPHRASE = new String(new byte[]{72, 52, 118, 51, 70, 117, 110, 87, 49, 55, 104, 56, 48, 110, 49, 55, 52}).toCharArray();
    private static final SecretKey SECRET_KEY = SimpleEncryptor.generateKey();

    private SimpleEncryptor() {
    }

    public static SecretKey generateKey() {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(PASSPHRASE, SALT, 1000, 256);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encrypt(byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, SECRET_KEY);
        byte[] encryptedBytes = cipher.doFinal(data);
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static byte[] decrypt(String encryptedData) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, SECRET_KEY);
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedData);
        return cipher.doFinal(decodedBytes);
    }
}

