/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.connector.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import lombok.Generated;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.bpm.flownode.impl.internal.NameExpressionMapAdapter;
import org.bonitasoft.engine.bpm.internal.NamedDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.impl.OperationImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConnectorDefinitionImpl
extends NamedDefinitionElementImpl
implements ConnectorDefinition {
    private static final long serialVersionUID = 1892648036453422626L;
    @XmlAttribute
    private final String connectorId;
    @XmlJavaTypeAdapter(value=NameExpressionMapAdapter.class)
    private final Map<String, Expression> inputs = new HashMap<String, Expression>();
    @XmlElementWrapper(name="outputs")
    @XmlElement(name="operation", type=OperationImpl.class)
    private final List<Operation> outputs = new ArrayList<Operation>();
    @XmlAttribute
    private final ConnectorEvent activationEvent;
    @XmlAttribute
    private final String version;
    @XmlAttribute
    private FailAction failAction = FailAction.FAIL;
    @XmlAttribute
    private String errorCode;

    public ConnectorDefinitionImpl(String name, String connectorId, String version, ConnectorEvent activationEvent) {
        super(name);
        this.connectorId = connectorId;
        this.version = version;
        this.activationEvent = activationEvent;
    }

    public ConnectorDefinitionImpl() {
        this.connectorId = "default id";
        this.version = "default version";
        this.activationEvent = ConnectorEvent.ON_ENTER;
    }

    public void addInput(String name, Expression expression) {
        this.inputs.put(name, ExpressionBuilder.getNonNullCopy(expression));
    }

    public void addOutput(Operation operation) {
        this.outputs.add(OperationBuilder.getNonNullCopy(operation));
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Override
    @Generated
    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    @Generated
    public Map<String, Expression> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public List<Operation> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public ConnectorEvent getActivationEvent() {
        return this.activationEvent;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public FailAction getFailAction() {
        return this.failAction;
    }

    @Override
    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorDefinitionImpl)) {
            return false;
        }
        ConnectorDefinitionImpl other = (ConnectorDefinitionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$connectorId = this.getConnectorId();
        String other$connectorId = other.getConnectorId();
        if (this$connectorId == null ? other$connectorId != null : !this$connectorId.equals(other$connectorId)) {
            return false;
        }
        Map<String, Expression> this$inputs = this.getInputs();
        Map<String, Expression> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<Operation> this$outputs = this.getOutputs();
        List<Operation> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        ConnectorEvent this$activationEvent = this.getActivationEvent();
        ConnectorEvent other$activationEvent = other.getActivationEvent();
        if (this$activationEvent == null ? other$activationEvent != null : !((Object)((Object)this$activationEvent)).equals((Object)other$activationEvent)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        FailAction this$failAction = this.getFailAction();
        FailAction other$failAction = other.getFailAction();
        if (this$failAction == null ? other$failAction != null : !((Object)((Object)this$failAction)).equals((Object)other$failAction)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConnectorDefinitionImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $connectorId = this.getConnectorId();
        result = result * 59 + ($connectorId == null ? 43 : $connectorId.hashCode());
        Map<String, Expression> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<Operation> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        ConnectorEvent $activationEvent = this.getActivationEvent();
        result = result * 59 + ($activationEvent == null ? 43 : ((Object)((Object)$activationEvent)).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        FailAction $failAction = this.getFailAction();
        result = result * 59 + ($failAction == null ? 43 : ((Object)((Object)$failAction)).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConnectorDefinitionImpl(connectorId=" + this.getConnectorId() + ", inputs=" + String.valueOf(this.getInputs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", activationEvent=" + String.valueOf((Object)this.getActivationEvent()) + ", version=" + this.getVersion() + ", failAction=" + String.valueOf((Object)this.getFailAction()) + ", errorCode=" + this.getErrorCode() + ")";
    }

    @Generated
    public void setFailAction(FailAction failAction) {
        this.failAction = failAction;
    }

    @Generated
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

