/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import lombok.Generated;
import org.bonitasoft.engine.bpm.NamedElement;
import org.bonitasoft.engine.bpm.ObjectSeeker;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.businessdata.impl.BusinessDataDefinitionImpl;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.impl.DataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.TextDataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.XMLDataDefinitionImpl;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.document.DocumentListDefinition;
import org.bonitasoft.engine.bpm.document.impl.DocumentDefinitionImpl;
import org.bonitasoft.engine.bpm.document.impl.DocumentListDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateCatchEventDefinition;
import org.bonitasoft.engine.bpm.flownode.IntermediateThrowEventDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.AutomaticTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.CallActivityDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ElementFinder;
import org.bonitasoft.engine.bpm.flownode.impl.internal.EndEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.GatewayDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateCatchEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.IntermediateThrowEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ManualTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.ReceiveTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.SendTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.StartEventDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.TransitionDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.UserTaskDefinitionImpl;
import org.bonitasoft.engine.bpm.internal.BaseDefinitionElementImpl;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.bpm.process.Visitable;
import org.bonitasoft.engine.bpm.process.impl.internal.SubProcessDefinitionImpl;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlowElementContainerDefinitionImpl
extends BaseDefinitionElementImpl
implements FlowElementContainerDefinition,
Visitable {
    private static final long serialVersionUID = 1L;
    @XmlElements(value={@XmlElement(type=AutomaticTaskDefinitionImpl.class, name="automaticTask"), @XmlElement(type=CallActivityDefinitionImpl.class, name="callActivity"), @XmlElement(type=ManualTaskDefinitionImpl.class, name="manualTask"), @XmlElement(type=ReceiveTaskDefinitionImpl.class, name="receiveTask"), @XmlElement(type=SendTaskDefinitionImpl.class, name="sendTask"), @XmlElement(type=UserTaskDefinitionImpl.class, name="userTask"), @XmlElement(type=SubProcessDefinitionImpl.class, name="subProcess")})
    private final List<ActivityDefinition> activities = new ArrayList<ActivityDefinition>();
    @XmlElementWrapper(name="transitions")
    @XmlElement(type=TransitionDefinitionImpl.class, name="transition")
    private final Set<TransitionDefinition> transitions = new HashSet<TransitionDefinition>();
    @XmlElement(type=GatewayDefinitionImpl.class, name="gateway")
    private final List<GatewayDefinition> gateways = new ArrayList<GatewayDefinition>();
    @XmlElement(type=StartEventDefinitionImpl.class, name="startEvent")
    private final List<StartEventDefinition> startEvents = new ArrayList<StartEventDefinition>(1);
    @XmlElement(type=IntermediateCatchEventDefinitionImpl.class, name="intermediateCatchEvent")
    private final List<IntermediateCatchEventDefinition> intermediateCatchEvents = new ArrayList<IntermediateCatchEventDefinition>(4);
    @XmlElement(type=IntermediateThrowEventDefinitionImpl.class, name="intermediateThrowEvent")
    private final List<IntermediateThrowEventDefinition> intermediateThrowEvents = new ArrayList<IntermediateThrowEventDefinition>(4);
    @XmlElement(type=EndEventDefinitionImpl.class, name="endEvent")
    private final List<EndEventDefinition> endEvents = new ArrayList<EndEventDefinition>(4);
    @XmlElementWrapper(name="dataDefinitions")
    @XmlElements(value={@XmlElement(type=DataDefinitionImpl.class, name="dataDefinition"), @XmlElement(type=TextDataDefinitionImpl.class, name="textDataDefinition"), @XmlElement(type=XMLDataDefinitionImpl.class, name="xmlDataDefinition")})
    private final List<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
    @XmlElementWrapper(name="businessDataDefinitions")
    @XmlElement(type=BusinessDataDefinitionImpl.class, name="businessDataDefinition")
    private final List<BusinessDataDefinition> businessDataDefinitions = new ArrayList<BusinessDataDefinition>();
    @XmlElementWrapper(name="documentDefinitions")
    @XmlElement(type=DocumentDefinitionImpl.class, name="documentDefinition")
    private final List<DocumentDefinition> documentDefinitions = new ArrayList<DocumentDefinition>();
    @XmlElementWrapper(name="documentListDefinitions")
    @XmlElement(type=DocumentListDefinitionImpl.class, name="documentListDefinition")
    private final List<DocumentListDefinition> documentListDefinitions = new ArrayList<DocumentListDefinition>();
    @XmlElementWrapper(name="connectors")
    @XmlElement(type=ConnectorDefinitionImpl.class, name="connector")
    private final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();
    @XmlElement
    private final ElementFinder elementFinder = new ElementFinder();

    @Override
    public FlowNodeDefinition getFlowNode(long sourceId) {
        return this.elementFinder.getElementById(this.getFlowNodes(), sourceId);
    }

    @Override
    public FlowNodeDefinition getFlowNode(String sourceName) {
        Set<FlowNodeDefinition> flowNodes = this.getFlowNodes();
        return this.getElementByName(flowNodes, sourceName);
    }

    private Set<FlowNodeDefinition> getFlowNodes() {
        HashSet<FlowNodeDefinition> flowNodes = new HashSet<FlowNodeDefinition>();
        flowNodes.addAll(this.gateways);
        flowNodes.addAll(this.activities);
        flowNodes.addAll(this.startEvents);
        flowNodes.addAll(this.intermediateCatchEvents);
        flowNodes.addAll(this.intermediateThrowEvents);
        flowNodes.addAll(this.endEvents);
        flowNodes.addAll(this.getBoundaryEvents());
        return Collections.unmodifiableSet(flowNodes);
    }

    private List<BoundaryEventDefinition> getBoundaryEvents() {
        ArrayList<BoundaryEventDefinition> boundaryEvents = new ArrayList<BoundaryEventDefinition>(3);
        for (ActivityDefinition activity : this.activities) {
            boundaryEvents.addAll(activity.getBoundaryEventDefinitions());
        }
        return boundaryEvents;
    }

    @Override
    public List<ActivityDefinition> getActivities() {
        return Collections.unmodifiableList(this.activities);
    }

    @Override
    public ActivityDefinition getActivity(String name) {
        return this.getElementByName(this.activities, name);
    }

    @Override
    public Set<TransitionDefinition> getTransitions() {
        return Collections.unmodifiableSet(this.transitions);
    }

    @Override
    @Deprecated
    public Set<GatewayDefinition> getGateways() {
        return Collections.unmodifiableSet(new HashSet<GatewayDefinition>(this.gateways));
    }

    @Override
    public List<GatewayDefinition> getGatewaysList() {
        return Collections.unmodifiableList(this.gateways);
    }

    @Override
    public GatewayDefinition getGateway(String name) {
        return this.getElementByName(this.gateways, name);
    }

    private <T extends NamedElement> T getElementByName(Collection<T> elements, String name) {
        NamedElement element = null;
        boolean found = false;
        Iterator<T> iterator = elements.iterator();
        while (!found && iterator.hasNext()) {
            NamedElement next = (NamedElement)iterator.next();
            if (!name.equals(next.getName())) continue;
            found = true;
            element = next;
        }
        return (T)element;
    }

    @Override
    public List<StartEventDefinition> getStartEvents() {
        return Collections.unmodifiableList(this.startEvents);
    }

    @Override
    public List<IntermediateCatchEventDefinition> getIntermediateCatchEvents() {
        return Collections.unmodifiableList(this.intermediateCatchEvents);
    }

    @Override
    public List<IntermediateThrowEventDefinition> getIntermediateThrowEvents() {
        return Collections.unmodifiableList(this.intermediateThrowEvents);
    }

    @Override
    public List<EndEventDefinition> getEndEvents() {
        return Collections.unmodifiableList(this.endEvents);
    }

    @Override
    public List<BusinessDataDefinition> getBusinessDataDefinitions() {
        return Collections.unmodifiableList(this.businessDataDefinitions);
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return Collections.unmodifiableList(this.dataDefinitions);
    }

    @Override
    public List<DocumentDefinition> getDocumentDefinitions() {
        return Collections.unmodifiableList(this.documentDefinitions);
    }

    @Override
    public List<DocumentListDefinition> getDocumentListDefinitions() {
        return Collections.unmodifiableList(this.documentListDefinitions);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addActivity(ActivityDefinition activity) {
        this.activities.add(activity);
    }

    public void addTransition(TransitionDefinition transition) {
        this.transitions.add(transition);
    }

    public void addGateway(GatewayDefinition gateway) {
        this.gateways.add(gateway);
    }

    public void addStartEvent(StartEventDefinition startEvent) {
        this.startEvents.add(startEvent);
    }

    public void addIntermediateCatchEvent(IntermediateCatchEventDefinition event) {
        this.intermediateCatchEvents.add(event);
    }

    public void addIntermediateThrowEvent(IntermediateThrowEventDefinition intermediateThrowEvent) {
        this.intermediateThrowEvents.add(intermediateThrowEvent);
    }

    public void addEndEvent(EndEventDefinition endEvent) {
        this.endEvents.add(endEvent);
    }

    public void addBusinessDataDefinition(BusinessDataDefinition businessDataDefinition) {
        this.businessDataDefinitions.add(businessDataDefinition);
    }

    public void addDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinitions.add(dataDefinition);
    }

    public void addDocumentDefinition(DocumentDefinition documentDefinition) {
        this.documentDefinitions.add(documentDefinition);
    }

    public void addDocumentListDefinition(DocumentListDefinition documentListDefinition) {
        this.documentListDefinitions.add(documentListDefinition);
    }

    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    @Override
    public BusinessDataDefinition getBusinessDataDefinition(String name) {
        return (BusinessDataDefinition)ObjectSeeker.getNamedElement(this.businessDataDefinitions, (String)name);
    }

    @Override
    public DataDefinition getDataDefinition(String name) {
        return (DataDefinition)ObjectSeeker.getNamedElement(this.dataDefinitions, (String)name);
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Generated
    public FlowElementContainerDefinitionImpl() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowElementContainerDefinitionImpl)) {
            return false;
        }
        FlowElementContainerDefinitionImpl other = (FlowElementContainerDefinitionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ActivityDefinition> this$activities = this.getActivities();
        List<ActivityDefinition> other$activities = other.getActivities();
        if (this$activities == null ? other$activities != null : !((Object)this$activities).equals(other$activities)) {
            return false;
        }
        Set<TransitionDefinition> this$transitions = this.getTransitions();
        Set<TransitionDefinition> other$transitions = other.getTransitions();
        if (this$transitions == null ? other$transitions != null : !((Object)this$transitions).equals(other$transitions)) {
            return false;
        }
        Set<GatewayDefinition> this$gateways = this.getGateways();
        Set<GatewayDefinition> other$gateways = other.getGateways();
        if (this$gateways == null ? other$gateways != null : !((Object)this$gateways).equals(other$gateways)) {
            return false;
        }
        List<StartEventDefinition> this$startEvents = this.getStartEvents();
        List<StartEventDefinition> other$startEvents = other.getStartEvents();
        if (this$startEvents == null ? other$startEvents != null : !((Object)this$startEvents).equals(other$startEvents)) {
            return false;
        }
        List<IntermediateCatchEventDefinition> this$intermediateCatchEvents = this.getIntermediateCatchEvents();
        List<IntermediateCatchEventDefinition> other$intermediateCatchEvents = other.getIntermediateCatchEvents();
        if (this$intermediateCatchEvents == null ? other$intermediateCatchEvents != null : !((Object)this$intermediateCatchEvents).equals(other$intermediateCatchEvents)) {
            return false;
        }
        List<IntermediateThrowEventDefinition> this$intermediateThrowEvents = this.getIntermediateThrowEvents();
        List<IntermediateThrowEventDefinition> other$intermediateThrowEvents = other.getIntermediateThrowEvents();
        if (this$intermediateThrowEvents == null ? other$intermediateThrowEvents != null : !((Object)this$intermediateThrowEvents).equals(other$intermediateThrowEvents)) {
            return false;
        }
        List<EndEventDefinition> this$endEvents = this.getEndEvents();
        List<EndEventDefinition> other$endEvents = other.getEndEvents();
        if (this$endEvents == null ? other$endEvents != null : !((Object)this$endEvents).equals(other$endEvents)) {
            return false;
        }
        List<DataDefinition> this$dataDefinitions = this.getDataDefinitions();
        List<DataDefinition> other$dataDefinitions = other.getDataDefinitions();
        if (this$dataDefinitions == null ? other$dataDefinitions != null : !((Object)this$dataDefinitions).equals(other$dataDefinitions)) {
            return false;
        }
        List<BusinessDataDefinition> this$businessDataDefinitions = this.getBusinessDataDefinitions();
        List<BusinessDataDefinition> other$businessDataDefinitions = other.getBusinessDataDefinitions();
        if (this$businessDataDefinitions == null ? other$businessDataDefinitions != null : !((Object)this$businessDataDefinitions).equals(other$businessDataDefinitions)) {
            return false;
        }
        List<DocumentDefinition> this$documentDefinitions = this.getDocumentDefinitions();
        List<DocumentDefinition> other$documentDefinitions = other.getDocumentDefinitions();
        if (this$documentDefinitions == null ? other$documentDefinitions != null : !((Object)this$documentDefinitions).equals(other$documentDefinitions)) {
            return false;
        }
        List<DocumentListDefinition> this$documentListDefinitions = this.getDocumentListDefinitions();
        List<DocumentListDefinition> other$documentListDefinitions = other.getDocumentListDefinitions();
        if (this$documentListDefinitions == null ? other$documentListDefinitions != null : !((Object)this$documentListDefinitions).equals(other$documentListDefinitions)) {
            return false;
        }
        List<ConnectorDefinition> this$connectors = this.getConnectors();
        List<ConnectorDefinition> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        ElementFinder this$elementFinder = this.elementFinder;
        ElementFinder other$elementFinder = other.elementFinder;
        return !(this$elementFinder == null ? other$elementFinder != null : !((Object)this$elementFinder).equals(other$elementFinder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowElementContainerDefinitionImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ActivityDefinition> $activities = this.getActivities();
        result = result * 59 + ($activities == null ? 43 : ((Object)$activities).hashCode());
        Set<TransitionDefinition> $transitions = this.getTransitions();
        result = result * 59 + ($transitions == null ? 43 : ((Object)$transitions).hashCode());
        Set<GatewayDefinition> $gateways = this.getGateways();
        result = result * 59 + ($gateways == null ? 43 : ((Object)$gateways).hashCode());
        List<StartEventDefinition> $startEvents = this.getStartEvents();
        result = result * 59 + ($startEvents == null ? 43 : ((Object)$startEvents).hashCode());
        List<IntermediateCatchEventDefinition> $intermediateCatchEvents = this.getIntermediateCatchEvents();
        result = result * 59 + ($intermediateCatchEvents == null ? 43 : ((Object)$intermediateCatchEvents).hashCode());
        List<IntermediateThrowEventDefinition> $intermediateThrowEvents = this.getIntermediateThrowEvents();
        result = result * 59 + ($intermediateThrowEvents == null ? 43 : ((Object)$intermediateThrowEvents).hashCode());
        List<EndEventDefinition> $endEvents = this.getEndEvents();
        result = result * 59 + ($endEvents == null ? 43 : ((Object)$endEvents).hashCode());
        List<DataDefinition> $dataDefinitions = this.getDataDefinitions();
        result = result * 59 + ($dataDefinitions == null ? 43 : ((Object)$dataDefinitions).hashCode());
        List<BusinessDataDefinition> $businessDataDefinitions = this.getBusinessDataDefinitions();
        result = result * 59 + ($businessDataDefinitions == null ? 43 : ((Object)$businessDataDefinitions).hashCode());
        List<DocumentDefinition> $documentDefinitions = this.getDocumentDefinitions();
        result = result * 59 + ($documentDefinitions == null ? 43 : ((Object)$documentDefinitions).hashCode());
        List<DocumentListDefinition> $documentListDefinitions = this.getDocumentListDefinitions();
        result = result * 59 + ($documentListDefinitions == null ? 43 : ((Object)$documentListDefinitions).hashCode());
        List<ConnectorDefinition> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        ElementFinder $elementFinder = this.elementFinder;
        result = result * 59 + ($elementFinder == null ? 43 : ((Object)$elementFinder).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowElementContainerDefinitionImpl(activities=" + String.valueOf(this.getActivities()) + ", transitions=" + String.valueOf(this.getTransitions()) + ", gateways=" + String.valueOf(this.getGateways()) + ", startEvents=" + String.valueOf(this.getStartEvents()) + ", intermediateCatchEvents=" + String.valueOf(this.getIntermediateCatchEvents()) + ", intermediateThrowEvents=" + String.valueOf(this.getIntermediateThrowEvents()) + ", endEvents=" + String.valueOf(this.getEndEvents()) + ", dataDefinitions=" + String.valueOf(this.getDataDefinitions()) + ", businessDataDefinitions=" + String.valueOf(this.getBusinessDataDefinitions()) + ", documentDefinitions=" + String.valueOf(this.getDocumentDefinitions()) + ", documentListDefinitions=" + String.valueOf(this.getDocumentListDefinitions()) + ", connectors=" + String.valueOf(this.getConnectors()) + ", elementFinder=" + String.valueOf(this.elementFinder) + ")";
    }
}

