/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.actor.impl.ActorDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.DescriptionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.internal.DesignProcessDefinitionImpl;

public class ActorDefinitionBuilder
extends ProcessBuilder
implements DescriptionBuilder {
    private final ActorDefinitionImpl actor;

    ActorDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, DesignProcessDefinitionImpl process, String actorName, boolean initiator) {
        super(process, processDefinitionBuilder);
        this.actor = (ActorDefinitionImpl)this.getActorByName(actorName);
        this.actor.setInitiator(initiator);
        if (initiator) {
            process.setActorInitiator(this.actor);
        }
        if (!this.getProcessDefinition().getActorsList().contains(this.actor)) {
            process.addActor(this.actor);
        }
    }

    @Override
    public ActorDefinitionBuilder addDescription(String description) {
        this.actor.setDescription(description);
        return this;
    }

    private ActorDefinition getActorByName(String name) {
        for (ActorDefinition actorDefinition : this.getProcessDefinition().getActorsList()) {
            if (!actorDefinition.getName().equals(name)) continue;
            return actorDefinition;
        }
        return new ActorDefinitionImpl(name);
    }
}

