/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.util.Collections;
import java.util.Map;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;
import org.springframework.util.Assert;

public abstract class SingleIndexResolver<S extends Session>
implements IndexResolver<S> {
    private final String indexName;

    protected SingleIndexResolver(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null");
        this.indexName = indexName;
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public abstract String resolveIndexValueFor(S var1);

    @Override
    public final Map<String, String> resolveIndexesFor(S session) {
        String indexValue = this.resolveIndexValueFor(session);
        return indexValue != null ? Collections.singletonMap(this.indexName, indexValue) : Collections.emptyMap();
    }
}

