/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.Order;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.CookieHttpSessionIdResolver;
import org.springframework.session.web.http.HttpSessionAdapter;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.session.web.http.OnCommittedResponseWrapper;
import org.springframework.session.web.http.OncePerRequestFilter;
import org.springframework.session.web.http.SessionRepositoryFilter;

@Order(value=-2147483598)
public class SessionRepositoryFilter<S extends Session>
extends OncePerRequestFilter {
    private static final String SESSION_LOGGER_NAME = SessionRepositoryFilter.class.getName().concat(".SESSION_LOGGER");
    private static final Log SESSION_LOGGER = LogFactory.getLog((String)SESSION_LOGGER_NAME);
    public static final String SESSION_REPOSITORY_ATTR = SessionRepository.class.getName();
    public static final String INVALID_SESSION_ID_ATTR = SESSION_REPOSITORY_ATTR + ".invalidSessionId";
    private static final String CURRENT_SESSION_ATTR = SESSION_REPOSITORY_ATTR + ".CURRENT_SESSION";
    public static final int DEFAULT_ORDER = -2147483598;
    private final SessionRepository<S> sessionRepository;
    private HttpSessionIdResolver httpSessionIdResolver = new CookieHttpSessionIdResolver();

    public SessionRepositoryFilter(SessionRepository<S> sessionRepository) {
        if (sessionRepository == null) {
            throw new IllegalArgumentException("sessionRepository cannot be null");
        }
        this.sessionRepository = sessionRepository;
    }

    public void setHttpSessionIdResolver(HttpSessionIdResolver httpSessionIdResolver) {
        if (httpSessionIdResolver == null) {
            throw new IllegalArgumentException("httpSessionIdResolver cannot be null");
        }
        this.httpSessionIdResolver = httpSessionIdResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        request.setAttribute(SESSION_REPOSITORY_ATTR, this.sessionRepository);
        SessionRepositoryRequestWrapper wrappedRequest = new SessionRepositoryRequestWrapper(request, response);
        SessionRepositoryResponseWrapper wrappedResponse = new SessionRepositoryResponseWrapper(wrappedRequest, response);
        try {
            filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedRequest.commitSession();
        }
    }

    @Override
    protected void doFilterNestedErrorDispatch(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.doFilterInternal(request, response, filterChain);
    }

    private final class SessionRepositoryRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletResponse response;
        private S requestedSession;
        private boolean requestedSessionCached;
        private String requestedSessionId;
        private Boolean requestedSessionIdValid;
        private boolean requestedSessionInvalidated;

        private SessionRepositoryRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.response = response;
        }

        private void commitSession() {
            HttpSessionWrapper wrappedSession = this.getCurrentSession();
            if (wrappedSession == null) {
                if (this.isInvalidateClientSession()) {
                    SessionRepositoryFilter.this.httpSessionIdResolver.expireSession((HttpServletRequest)this, this.response);
                }
            } else {
                Object session = wrappedSession.getSession();
                this.clearRequestedSessionCache();
                SessionRepositoryFilter.this.sessionRepository.save(session);
                String sessionId = session.getId();
                if (!this.isRequestedSessionIdValid() || !sessionId.equals(this.getRequestedSessionId())) {
                    SessionRepositoryFilter.this.httpSessionIdResolver.setSessionId((HttpServletRequest)this, this.response, sessionId);
                }
            }
        }

        private org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getCurrentSession() {
            return (HttpSessionWrapper)this.getAttribute(CURRENT_SESSION_ATTR);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void setCurrentSession(HttpSessionWrapper currentSession) {
            if (currentSession == null) {
                this.removeAttribute(CURRENT_SESSION_ATTR);
            } else {
                this.setAttribute(CURRENT_SESSION_ATTR, currentSession);
            }
        }

        public String changeSessionId() {
            HttpSession session = this.getSession(false);
            if (session == null) {
                throw new IllegalStateException("Cannot change session ID. There is no session associated with this request.");
            }
            return this.getCurrentSession().getSession().changeSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            if (this.requestedSessionIdValid == null) {
                Object requestedSession = this.getRequestedSession();
                if (requestedSession != null) {
                    requestedSession.setLastAccessedTime(Instant.now());
                }
                return this.isRequestedSessionIdValid(requestedSession);
            }
            return this.requestedSessionIdValid;
        }

        private boolean isRequestedSessionIdValid(S session) {
            if (this.requestedSessionIdValid == null) {
                this.requestedSessionIdValid = session != null;
            }
            return this.requestedSessionIdValid;
        }

        private boolean isInvalidateClientSession() {
            return this.getCurrentSession() == null && this.requestedSessionInvalidated;
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession(boolean create) {
            HttpSessionWrapper currentSession = this.getCurrentSession();
            if (currentSession != null) {
                return currentSession;
            }
            Object requestedSession = this.getRequestedSession();
            if (requestedSession != null) {
                if (this.getAttribute(INVALID_SESSION_ID_ATTR) == null) {
                    requestedSession.setLastAccessedTime(Instant.now());
                    this.requestedSessionIdValid = true;
                    currentSession = new HttpSessionWrapper(this, requestedSession, this.getServletContext());
                    currentSession.markNotNew();
                    this.setCurrentSession(currentSession);
                    return currentSession;
                }
            } else {
                if (SESSION_LOGGER.isDebugEnabled()) {
                    SESSION_LOGGER.debug((Object)"No session found by id: Caching result for getSession(false) for this HttpServletRequest.");
                }
                this.setAttribute(INVALID_SESSION_ID_ATTR, "true");
            }
            if (!create) {
                return null;
            }
            if (SessionRepositoryFilter.this.httpSessionIdResolver instanceof CookieHttpSessionIdResolver && this.response.isCommitted()) {
                throw new IllegalStateException("Cannot create a session after the response has been committed");
            }
            if (SESSION_LOGGER.isDebugEnabled()) {
                SESSION_LOGGER.debug((Object)("A new session was created. To help you troubleshoot where the session was created we provided a StackTrace (this is not an error). You can prevent this from appearing by disabling DEBUG logging for " + SESSION_LOGGER_NAME), (Throwable)new RuntimeException("For debugging purposes only (not an error)"));
            }
            Object session = SessionRepositoryFilter.this.sessionRepository.createSession();
            session.setLastAccessedTime(Instant.now());
            currentSession = new HttpSessionWrapper(this, session, this.getServletContext());
            this.setCurrentSession(currentSession);
            return currentSession;
        }

        public org.springframework.session.web.http.SessionRepositoryFilter$SessionRepositoryRequestWrapper.HttpSessionWrapper getSession() {
            return this.getSession(true);
        }

        public String getRequestedSessionId() {
            if (this.requestedSessionId == null) {
                this.getRequestedSession();
            }
            return this.requestedSessionId;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcher requestDispatcher = super.getRequestDispatcher(path);
            return new SessionCommittingRequestDispatcher(requestDispatcher);
        }

        private S getRequestedSession() {
            if (!this.requestedSessionCached) {
                List<String> sessionIds = SessionRepositoryFilter.this.httpSessionIdResolver.resolveSessionIds((HttpServletRequest)this);
                for (String sessionId : sessionIds) {
                    Object session;
                    if (this.requestedSessionId == null) {
                        this.requestedSessionId = sessionId;
                    }
                    if ((session = SessionRepositoryFilter.this.sessionRepository.findById(sessionId)) == null) continue;
                    this.requestedSession = session;
                    this.requestedSessionId = sessionId;
                    break;
                }
                this.requestedSessionCached = true;
            }
            return this.requestedSession;
        }

        private void clearRequestedSessionCache() {
            this.requestedSessionCached = false;
            this.requestedSession = null;
            this.requestedSessionId = null;
        }

        private static final class HttpSessionWrapper
        extends HttpSessionAdapter<S> {
            final /* synthetic */ SessionRepositoryRequestWrapper this$1;

            HttpSessionWrapper(S session, ServletContext servletContext) {
                this.this$1 = var1_1;
                super(session, servletContext);
            }

            @Override
            public void invalidate() {
                super.invalidate();
                this.this$1.requestedSessionInvalidated = true;
                this.this$1.setCurrentSession(null);
                this.this$1.clearRequestedSessionCache();
                this.this$1.SessionRepositoryFilter.this.sessionRepository.deleteById(this.getId());
            }
        }

        private final class SessionCommittingRequestDispatcher
        implements RequestDispatcher {
            private final RequestDispatcher delegate;

            SessionCommittingRequestDispatcher(RequestDispatcher delegate) {
                this.delegate = delegate;
            }

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                this.delegate.forward(request, response);
            }

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                SessionRepositoryRequestWrapper.this.commitSession();
                this.delegate.include(request, response);
            }
        }
    }

    private final class SessionRepositoryResponseWrapper
    extends OnCommittedResponseWrapper {
        private final SessionRepositoryRequestWrapper request;

        SessionRepositoryResponseWrapper(SessionRepositoryRequestWrapper request, HttpServletResponse response) {
            super(response);
            if (request == null) {
                throw new IllegalArgumentException("request cannot be null");
            }
            this.request = request;
        }

        @Override
        protected void onResponseCommitted() {
            this.request.commitSession();
        }
    }
}

