/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth.impl.jaas;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.bonitasoft.console.common.server.auth.impl.jaas.ConsolePrincipal;
import org.bonitasoft.console.common.server.login.credentials.LoginDatastore;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;

public class ConsoleIdentityLoginModule
implements LoginModule {
    private static final String NAME_PROMPT = "Name: ";
    private static final String PASSWORD_PROMPT = "Password: ";
    protected static final String JAVAX_SECURITY_AUTH_LOGIN_PASSWORD = "javax.security.auth.login.password";
    protected static final String JAVAX_SECURITY_AUTH_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String DEBUG_OPTION_NAME = "debug";
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map<String, Object> sharedState;
    private boolean debug = false;
    private String id;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String debugFlag = (String)options.get(DEBUG_OPTION_NAME);
        if (debugFlag != null) {
            this.debug = Boolean.valueOf(debugFlag);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.debug) {
            System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] login() - preparing - step 1");
        }
        try {
            APISession aAPISession;
            Map<String, Object> loggingsArgs = this.getSharedState();
            Map<String, Callback> callbacks = this.getPromptCallbacks(loggingsArgs);
            if (!callbacks.isEmpty()) {
                if (this.debug) {
                    System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] login() - callback - step 2");
                }
                this.callbackHandler.handle(callbacks.values().toArray(new Callback[0]));
                this.adjustLoggingsArgs(callbacks, loggingsArgs);
            }
            if (this.isDebug()) {
                System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] login() - authenticating - step 3");
            }
            APISession aPISession = aAPISession = loggingsArgs.containsKey(JAVAX_SECURITY_AUTH_LOGIN_NAME) ? this.doLogin(loggingsArgs) : null;
            if (this.isDebug()) {
                System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] login() - storing data - step 4");
            }
            if (aAPISession != null) {
                this.id = (String)this.getSharedState().get(JAVAX_SECURITY_AUTH_LOGIN_NAME);
            }
            if (this.isDebug()) {
                System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] login() - returning - step 5");
            }
            if (this.id == null) {
                throw new FailedLoginException("id is null");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    protected APISession doLogin(Map<String, Object> loggingsArgs) throws BonitaException {
        LoginDatastore loginDatastore = new LoginDatastore();
        return loginDatastore.login(String.valueOf(loggingsArgs.get(JAVAX_SECURITY_AUTH_LOGIN_NAME)), String.valueOf(loggingsArgs.get(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD)));
    }

    protected Map<String, Callback> getPromptCallbacks(Map<String, Object> loggingsArgs) {
        HashMap<String, Callback> callbacks = new HashMap<String, Callback>();
        if (!loggingsArgs.containsKey(JAVAX_SECURITY_AUTH_LOGIN_NAME)) {
            callbacks.put(NAME_PROMPT, new NameCallback(NAME_PROMPT));
        }
        if (!loggingsArgs.containsKey(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD)) {
            callbacks.put(PASSWORD_PROMPT, new PasswordCallback(PASSWORD_PROMPT, false));
        }
        return callbacks;
    }

    protected void adjustLoggingsArgs(Map<String, Callback> callbacks, Map<String, Object> loggingsArgs) {
        Callback callback;
        if (!loggingsArgs.containsKey(JAVAX_SECURITY_AUTH_LOGIN_NAME) && callbacks.get(NAME_PROMPT) instanceof NameCallback) {
            loggingsArgs.put(JAVAX_SECURITY_AUTH_LOGIN_NAME, ((NameCallback)callbacks.get(NAME_PROMPT)).getName());
        }
        if (!loggingsArgs.containsKey(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD) && (callback = callbacks.get(PASSWORD_PROMPT)) instanceof PasswordCallback) {
            PasswordCallback pwdCallback = (PasswordCallback)callback;
            loggingsArgs.put(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD, String.valueOf(pwdCallback.getPassword()));
            pwdCallback.clearPassword();
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.id == null) {
            throw new FailedLoginException("id is null");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new ConsolePrincipal(this.id));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] abort()");
        }
        if (this.id == null) {
            return false;
        }
        this.subject = null;
        this.id = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.id != null) {
            if (this.debug) {
                System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] logout() - removing principals");
            }
            HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
            for (Principal p : principals) {
                if (!(p instanceof ConsolePrincipal)) continue;
                if (this.debug) {
                    System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] logout() - removing principal: " + String.valueOf(p));
                }
                this.subject.getPrincipals().remove(p);
            }
            if (this.debug) {
                System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] logout() - destroying/removing credentials");
            }
            HashSet<Object> credentials = new HashSet<Object>(this.subject.getPublicCredentials());
            for (Object e : credentials) {
                if (e instanceof Destroyable && this.debug) {
                    System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] logout() - destroying credential: " + String.valueOf(e));
                }
                if (this.subject.isReadOnly()) continue;
                if (this.debug) {
                    System.err.println("[" + ConsoleIdentityLoginModule.class.getName() + "] logout() - removing credential: " + String.valueOf(e));
                }
                this.subject.getPublicCredentials().remove(e);
            }
        }
        return true;
    }

    protected Map<String, Object> getSharedState() {
        return this.sharedState;
    }

    protected boolean isDebug() {
        return this.debug;
    }
}

