/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth.impl.standard;

import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.auth.AuthenticationFailedException;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerProperties;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.credentials.Credentials;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.console.common.server.utils.UrlBuilder;
import org.bonitasoft.engine.properties.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthenticationManagerImpl
implements AuthenticationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StandardAuthenticationManagerImpl.class.getName());
    protected String loginPageURL = null;

    @Override
    public String getLoginPageURL(HttpServletRequestAccessor request, String redirectURL) throws ServletException {
        UrlBuilder loginURL = new UrlBuilder(this.getLoginPage(request));
        String localeFromRequestedURL = LocaleUtils.getLocaleFromRequestURL(request.asHttpServletRequest());
        if (localeFromRequestedURL != null) {
            loginURL.appendParameter("_l", localeFromRequestedURL);
        }
        if (StringUtils.isNotBlank((CharSequence)redirectURL)) {
            String decodedRedirectURL = URLDecoder.decode(redirectURL, StandardCharsets.UTF_8);
            loginURL.appendParameter("redirectUrl", decodedRedirectURL);
        }
        return loginURL.build();
    }

    @Override
    public Map<String, Serializable> authenticate(HttpServletRequestAccessor requestAccessor, Credentials credentials) throws AuthenticationFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("#authenticate (this implementation of " + AuthenticationManager.class.getName() + " does nothing. The subsequent engine login is enough to authenticate the user.)");
        }
        return Collections.emptyMap();
    }

    @Override
    public String getLogoutPageURL(HttpServletRequestAccessor request, String redirectURL) throws ServletException {
        return null;
    }

    protected String getLoginPage(HttpServletRequestAccessor requestAccessor) {
        if (this.loginPageURL == null) {
            StringProperty loginPage = new StringProperty("External Login URL", "bonita.runtime.authentication.login.url", this.getAuthenticationProperty("bonita.runtime.authentication.login.url", this.getDefaultLoginPage(requestAccessor)));
            this.loginPageURL = loginPage.getValue();
        }
        return this.loginPageURL;
    }

    protected String getDefaultLoginPage(HttpServletRequestAccessor requestAccessor) {
        StringBuilder url = new StringBuilder();
        String context = requestAccessor.asHttpServletRequest().getContextPath();
        url.append(context).append("/login.jsp");
        return url.toString();
    }

    protected String getAuthenticationProperty(String propertyName, String defaultValue) {
        String propertyValue = AuthenticationManagerProperties.getProperties().getTenantProperty(propertyName);
        return propertyValue != null ? propertyValue : defaultValue;
    }
}

