/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.engine.mdc.AbstractMDC;
import org.bonitasoft.engine.mdc.MDCHelper;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class RequestIdFilter
implements Filter {
    private String requestIdAttributeName = PropertiesFactory.getConsoleProperties().getRequestIdAttributeName();
    private String requestIdHeaderName = PropertiesFactory.getConsoleProperties().getRequestIdHeaderName();
    private String correlationIdAttributeName = PropertiesFactory.getConsoleProperties().getCorrelationIdAttributeName();
    private String correlationIdHeaderName = PropertiesFactory.getConsoleProperties().getCorrelationIdHeaderName();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<String> attachedReqIdAtt = Optional.ofNullable((String)request.getAttribute(this.requestIdAttributeName));
        String requestId = attachedReqIdAtt.orElseGet(() -> {
            String headerRequestId = null;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                headerRequestId = httpRequest.getHeader(this.requestIdHeaderName);
            }
            String id = Optional.ofNullable(headerRequestId).orElseGet(() -> Long.toHexString(System.nanoTime()));
            request.setAttribute(this.requestIdAttributeName, (Object)id);
            return id;
        });
        Optional<String> attachedCorrelIdAtt = Optional.ofNullable((String)request.getAttribute(this.correlationIdAttributeName));
        Optional<String> correlationId = attachedCorrelIdAtt.or(() -> {
            String headerCorrelId = null;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                headerCorrelId = httpRequest.getHeader(this.correlationIdHeaderName);
            }
            Optional<Object> id = Optional.ofNullable(headerCorrelId);
            id.ifPresent(i -> request.setAttribute(this.correlationIdAttributeName, i));
            return id;
        });
        Supplier<AbstractMDC> mdc = () -> new AbstractMDC(RequestIdFilter.buildContextMap(requestId, correlationId, request)){};
        MDCHelper.CheckedRunnable2 call = () -> chain.doFilter(request, response);
        MDCHelper.tryWithMDC(mdc, (MDCHelper.CheckedRunnable4)call);
    }

    private static Map<String, String> buildContextMap(String requestId, Optional<String> correlationId, ServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("req.requestId", Objects.requireNonNull(requestId));
        Predicate<String> isBlank = StringUtil::isBlank;
        correlationId.filter(isBlank.negate()).ifPresent(id -> map.put("req.correlationId", Objects.requireNonNull(id)));
        map.put("req.remoteHost", request.getRemoteHost());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            map.put("req.requestURI", http.getRequestURI());
            Optional.ofNullable(http.getRequestURL()).ifPresent(url -> map.put("req.requestURL", url.toString()));
            map.put("req.method", http.getMethod());
            Optional.ofNullable(http.getQueryString()).ifPresent(str -> map.put("req.queryString", (String)str));
            Optional.ofNullable(http.getHeader("User-Agent")).ifPresent(agent -> map.put("req.userAgent", (String)agent));
            Optional.ofNullable(http.getHeader("X-Forwarded-For")).ifPresent(forwarded -> map.put("req.xForwardedFor", (String)forwarded));
        }
        return map;
    }
}

