/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.form;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.form.ProcessFormService;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.utils.UrlBuilder;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFormServlet
extends HttpServlet {
    private static final long serialVersionUID = -6397856355139281873L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessFormServlet.class.getName());
    private static final String PAGE_SERVLET_MAPPING = "/portal/resource/";
    private static final String PROCESS_PATH_SEGMENT = "process";
    private static final String PROCESS_INSTANCE_PATH_SEGMENT = "processInstance";
    private static final String TASK_INSTANCE_PATH_SEGMENT = "taskInstance";
    private static final String TASK_PATH_SEGMENT = "task";
    private static final String USER_ID_PARAM = "user";
    private static final String ID_PARAM = "id";
    protected ProcessFormService processFormService = new ProcessFormService();
    private final ResourceRenderer resourceRenderer = new ResourceRenderer();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long processDefinitionId = -1L;
        long processInstanceId = -1L;
        long taskInstanceId = -1L;
        String taskName = null;
        List<String> pathSegments = this.resourceRenderer.getPathSegments(request.getPathInfo());
        String user = request.getParameter(USER_ID_PARAM);
        long userId = this.convertToLong(USER_ID_PARAM, user);
        HttpSession session = request.getSession();
        APISession apiSession = (APISession)session.getAttribute("apiSession");
        try {
            if (pathSegments.size() > 1) {
                taskInstanceId = this.getTaskInstanceId(apiSession, pathSegments, userId);
                processInstanceId = this.getProcessInstanceId(pathSegments);
                processDefinitionId = this.getProcessDefinitionId(apiSession, pathSegments);
            }
            if (processDefinitionId == -1L && processInstanceId == -1L && taskInstanceId == -1L) {
                response.sendError(400, "Either process name and version are required or process instance Id (with or without task name) or task instance Id.");
                return;
            }
            processDefinitionId = this.processFormService.ensureProcessDefinitionId(apiSession, processDefinitionId, processInstanceId, taskInstanceId);
            taskName = this.processFormService.getTaskName(apiSession, taskInstanceId);
            this.redirectToPageServlet(request, response, apiSession, processDefinitionId, processInstanceId, taskInstanceId, taskName);
        }
        catch (Exception e) {
            this.handleException(response, processDefinitionId, taskName, processInstanceId != -1L, e);
        }
    }

    protected void redirectToPageServlet(HttpServletRequest request, HttpServletResponse response, APISession apiSession, long processDefinitionId, long processInstanceId, long taskInstanceId, String taskName) throws BonitaException, IOException {
        String pageServletURL = this.buildPageServletURL(request, apiSession, processDefinitionId, processInstanceId, taskInstanceId, taskName);
        UrlBuilder urlBuilder = new UrlBuilder(pageServletURL);
        urlBuilder.appendParameters(request.getParameterMap());
        response.sendRedirect(response.encodeRedirectURL(urlBuilder.build()));
    }

    protected String buildPageServletURL(HttpServletRequest request, APISession apiSession, long processDefinitionId, long processInstanceId, long taskInstanceId, String taskName) throws BonitaException, IOException {
        StringBuilder pageServletURL = new StringBuilder(request.getContextPath());
        pageServletURL.append(PAGE_SERVLET_MAPPING);
        if (taskInstanceId != -1L) {
            pageServletURL.append(TASK_INSTANCE_PATH_SEGMENT).append("/").append(this.processFormService.getProcessPath(apiSession, processDefinitionId)).append("/").append(this.processFormService.encodePathSegment(taskName)).append("/content").append("/?").append(ID_PARAM).append("=").append(taskInstanceId);
        } else if (processInstanceId != -1L) {
            pageServletURL.append(PROCESS_INSTANCE_PATH_SEGMENT).append("/").append(this.processFormService.getProcessPath(apiSession, processDefinitionId)).append("/content").append("/?").append(ID_PARAM).append("=").append(processInstanceId);
        } else {
            pageServletURL.append(PROCESS_PATH_SEGMENT).append("/").append(this.processFormService.getProcessPath(apiSession, processDefinitionId)).append("/content").append("/?").append(ID_PARAM).append("=").append(processDefinitionId);
        }
        return pageServletURL.toString();
    }

    protected long getProcessInstanceId(List<String> pathSegments) {
        long processInstanceId = -1L;
        if (PROCESS_INSTANCE_PATH_SEGMENT.equals(pathSegments.get(0))) {
            String processInstance = pathSegments.get(1);
            processInstanceId = this.convertToLong(PROCESS_INSTANCE_PATH_SEGMENT, processInstance);
        }
        return processInstanceId;
    }

    protected long getTaskInstanceId(APISession apiSession, List<String> pathSegments, long userId) throws BonitaException {
        if (TASK_INSTANCE_PATH_SEGMENT.equals(pathSegments.get(0))) {
            String taskInstance = pathSegments.get(1);
            return this.convertToLong(TASK_INSTANCE_PATH_SEGMENT, taskInstance);
        }
        if (PROCESS_INSTANCE_PATH_SEGMENT.equals(pathSegments.get(0))) {
            String processInstance = pathSegments.get(1);
            long processInstanceId = this.convertToLong(PROCESS_INSTANCE_PATH_SEGMENT, processInstance);
            if (pathSegments.size() > 2 && TASK_PATH_SEGMENT.equals(pathSegments.get(2))) {
                String taskName = URLDecoder.decode(pathSegments.get(3), StandardCharsets.UTF_8);
                return this.processFormService.getTaskInstanceId(apiSession, processInstanceId, taskName, userId);
            }
        }
        return -1L;
    }

    protected long getProcessDefinitionId(APISession apiSession, List<String> pathSegments) throws BonitaException {
        long processDefinitionId = -1L;
        if (PROCESS_PATH_SEGMENT.equals(pathSegments.get(0)) && pathSegments.size() > 2) {
            String processName = pathSegments.get(1);
            String processVersion = pathSegments.get(2);
            processDefinitionId = this.processFormService.getProcessDefinitionId(apiSession, processName, processVersion);
        }
        return processDefinitionId;
    }

    protected long convertToLong(String parameterName, String idAsString) {
        block3: {
            if (idAsString != null) {
                try {
                    return Long.parseLong(idAsString);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isInfoEnabled()) break block3;
                    LOGGER.info("Wrong value for " + parameterName + " expecting a number (long value)");
                }
            }
        }
        return -1L;
    }

    protected void handleException(HttpServletResponse response, long processDefinitionId, String taskName, boolean hasProcessInstanceId, Exception e) throws ServletException {
        try {
            if (e instanceof ProcessDefinitionNotFoundException) {
                response.sendError(404, "Cannot find the process");
            } else if (e instanceof ArchivedProcessInstanceNotFoundException) {
                response.sendError(404, "Cannot find the process instance");
            } else if (e instanceof ActivityInstanceNotFoundException) {
                response.sendError(404, "Cannot find the task instance");
            } else {
                if (LOGGER.isWarnEnabled()) {
                    Object message = "Error while trying to display a form";
                    if (processDefinitionId != -1L) {
                        message = (String)message + " for process " + processDefinitionId;
                    }
                    if (taskName != null) {
                        message = (String)message + " for task " + taskName;
                    } else if (hasProcessInstanceId) {
                        message = (String)message + " ( instance overview)";
                    }
                    LOGGER.warn((String)message, (Throwable)e);
                }
                response.sendError(500, e.getMessage());
            }
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
    }
}

