/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.filter.AuthenticationRule;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.user.User;

public class AlreadyLoggedInRule
extends AuthenticationRule {
    @Override
    public boolean doAuthorize(HttpServletRequestAccessor request, HttpServletResponse response) throws ServletException {
        if (this.isUserAlreadyLoggedIn(request)) {
            this.ensureUserSession(request.asHttpServletRequest(), request.getHttpSession(), request.getApiSession());
            return true;
        }
        return false;
    }

    protected boolean isUserAlreadyLoggedIn(HttpServletRequestAccessor request) throws ServletException {
        String requestPath;
        HttpServletRequest httpServletRequest = request.asHttpServletRequest();
        if (httpServletRequest.getPathInfo() != null && (requestPath = httpServletRequest.getServletPath() + httpServletRequest.getPathInfo()).matches("^/(API|APIToolkit)/platform/.*")) {
            return request.getHttpSession().getAttribute("platformSession") != null;
        }
        return request.getApiSession() != null;
    }

    private void ensureUserSession(HttpServletRequest request, HttpSession session, APISession apiSession) {
        if (apiSession != null && session.getAttribute("user") == null) {
            this.reCreateUser(request, session, apiSession);
        }
    }

    private void reCreateUser(HttpServletRequest request, HttpSession session, APISession apiSession) {
        String locale = this.getLocale(request);
        User user = new User(apiSession.getUserName(), locale);
        session.setAttribute("user", (Object)user);
    }

    private String getLocale(HttpServletRequest request) {
        return LocaleUtils.getUserLocaleAsString(request);
    }
}

