/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;

public class ContentTypeSecurityFilter
extends ExcludingPatternFilter {
    protected static final String X_CONTENT_TYPE_HEADER = "X-Content-Type-Options";
    protected String headerValue;

    @Override
    public String getDefaultExcludedPages() {
        return "";
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.headerValue = (String)StringUtils.defaultIfEmpty((CharSequence)filterConfig.getInitParameter(X_CONTENT_TYPE_HEADER), (CharSequence)"nosniff");
        super.init(filterConfig);
    }

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setHeader(X_CONTENT_TYPE_HEADER, this.headerValue);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }
}

