/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.login.PortalCookies;
import org.bonitasoft.console.common.server.login.filter.TokenGenerator;

public class TokenGeneratorFilter
implements Filter {
    protected TokenGenerator tokenGenerator = new TokenGenerator();
    protected PortalCookies portalCookies = new PortalCookies();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String apiTokenFromClient = this.tokenGenerator.createOrLoadToken(req.getSession());
        this.tokenGenerator.setTokenToResponseHeader(res, apiTokenFromClient);
        this.portalCookies.addCSRFTokenCookieToResponse(req, res, apiTokenFromClient);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

