/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.page.BDMClientDependenciesResolver;
import org.bonitasoft.console.common.server.page.CustomPageDependenciesResolver;
import org.bonitasoft.console.common.server.page.MonoParentJarFileClassLoader;
import org.bonitasoft.console.common.server.page.VersionedClassloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPageChildFirstClassLoader
extends MonoParentJarFileClassLoader
implements VersionedClassloader {
    protected final Map<String, byte[]> nonJarResources = new HashMap<String, byte[]>();
    private boolean isActive = true;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomPageChildFirstClassLoader.class.getName());
    private final CustomPageDependenciesResolver customPageDependenciesResolver;
    private final BDMClientDependenciesResolver bdmDependenciesResolver;
    private final String version;

    CustomPageChildFirstClassLoader(String pageName, CustomPageDependenciesResolver customPageDependenciesResolver, BDMClientDependenciesResolver bdmDependenciesResolver, ClassLoader parent) {
        super(pageName, new URL[0], parent);
        this.customPageDependenciesResolver = customPageDependenciesResolver;
        this.bdmDependenciesResolver = bdmDependenciesResolver;
        this.version = bdmDependenciesResolver.getBusinessDataModelVersion();
    }

    public void addCustomPageResources() throws IOException {
        this.addBDMDependencies();
        this.addOtherDependencies();
    }

    private void addBDMDependencies() {
        try {
            this.addURLs(this.bdmDependenciesResolver.getBDMDependencies());
        }
        catch (IOException e) {
            LOGGER.error("Failed to add BDM dependencies in ClassLoader", (Throwable)e);
        }
    }

    private void addOtherDependencies() throws IOException {
        Map<String, byte[]> customPageDependencies = this.customPageDependenciesResolver.resolveCustomPageDependencies();
        for (Map.Entry<String, byte[]> resource : customPageDependencies.entrySet()) {
            if (resource.getKey().matches(".*\\.jar") && !this.bdmDependenciesResolver.isABDMDependency(resource.getKey())) {
                byte[] data = resource.getValue();
                File file = File.createTempFile(resource.getKey(), null, this.customPageDependenciesResolver.getTempFolder());
                file.deleteOnExit();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                this.addURL(new File(file.getAbsolutePath()).toURI().toURL());
                continue;
            }
            this.nonJarResources.put(resource.getKey(), resource.getValue());
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = this.getResourceAsStreamInternal(name);
        if (is == null && name.length() > 0 && name.charAt(0) == '/') {
            is = this.getResourceAsStreamInternal(name.substring(1));
        }
        return is;
    }

    protected InputStream getResourceAsStreamInternal(String name) {
        byte[] classData = this.loadProcessResource(name);
        if (classData != null) {
            return new ByteArrayInputStream(classData);
        }
        return this.getResourceAsStreamRegular(name);
    }

    protected InputStream getResourceAsStreamRegular(String name) {
        return super.getResourceAsStream(name);
    }

    private byte[] loadProcessResource(String resourceName) {
        return this.nonJarResources.containsKey(resourceName) ? this.nonJarResources.get(resourceName) : null;
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block6: {
            c = null;
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError le) {
                    c = this.findLoadedClass(name);
                    if (c != null) break block6;
                    throw le;
                }
            }
        }
        if (c == null) {
            c = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void release() {
        FileUtils.deleteQuietly((File)this.customPageDependenciesResolver.getTempFolder());
        this.isActive = false;
    }

    public String toString() {
        return super.toString() + ", name=" + this.getName() + ", isActive: " + this.isActive + ", parent= " + String.valueOf(this.getParent());
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean hasVersion(String version) {
        return Objects.equals(this.getVersion(), version);
    }
}

