/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class CustomPageRequestModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomPageRequestModifier.class.getName());

    public void redirectToValidPageUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder taskURLBuilder = new StringBuilder(request.getContextPath());
        taskURLBuilder.append(request.getServletPath());
        if (request.getPathInfo() != null) {
            taskURLBuilder.append(request.getPathInfo());
        }
        taskURLBuilder.append("/");
        if (!StringUtil.isBlank(request.getQueryString())) {
            taskURLBuilder.append("?").append(request.getQueryString());
        }
        response.sendRedirect(response.encodeRedirectURL(taskURLBuilder.toString()));
    }

    public void forwardIfRequestIsAuthorized(HttpServletRequest request, HttpServletResponse response, String apiPathShouldStartWith, String apiPath) throws IOException, ServletException {
        try {
            String encodedAPIPath = UriUtils.encodePath((String)apiPath, (String)"UTF-8");
            URI uri = new URI(encodedAPIPath);
            if (!uri.normalize().toString().startsWith(apiPathShouldStartWith)) {
                String message = "attempt to access unauthorized path " + encodedAPIPath;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(message);
                }
                response.setStatus(403);
                response.flushBuffer();
            } else {
                request.getRequestDispatcher(encodedAPIPath).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage());
            }
            response.setStatus(400);
            response.flushBuffer();
        }
    }
}

