/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.page.ApplicationAuthorizationsHelper;
import org.bonitasoft.console.common.server.page.CustomPageRequestModifier;
import org.bonitasoft.console.common.server.page.PageRenderer;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnauthorizedAccessException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.livingapps.ApplicationModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPageServlet
extends HttpServlet {
    public static final String APP_TOKEN_PARAM = "appToken";
    private static final long serialVersionUID = -5410859017103815654L;
    private static Logger LOGGER = LoggerFactory.getLogger((String)CustomPageServlet.class.getName());
    protected ResourceRenderer resourceRenderer = new ResourceRenderer();
    protected PageRenderer pageRenderer = new PageRenderer(this.resourceRenderer);
    protected BonitaHomeFolderAccessor bonitaHomeFolderAccessor = new BonitaHomeFolderAccessor();
    protected CustomPageRequestModifier customPageRequestModifier = new CustomPageRequestModifier();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isPageUrlWithoutFinalSlash(request)) {
            this.customPageRequestModifier.redirectToValidPageUrl(request, response);
            return;
        }
        String appToken = request.getParameter(APP_TOKEN_PARAM);
        HttpSession session = request.getSession();
        APISession apiSession = (APISession)session.getAttribute("apiSession");
        List<String> pathSegments = this.resourceRenderer.getPathSegments(request.getPathInfo());
        if (pathSegments.isEmpty()) {
            response.sendError(400, "The name of the page is required.");
            return;
        }
        String pageName = pathSegments.get(0);
        try {
            if (this.isAuthorized(apiSession, appToken)) {
                if (this.isPageRequest(pathSegments)) {
                    this.pageRenderer.displayCustomPage(request, response, apiSession, pageName);
                } else {
                    File resourceFile = this.getResourceFile(request.getPathInfo(), pageName);
                    this.pageRenderer.ensurePageFolderIsPresent(apiSession, this.pageRenderer.getPageResourceProvider(pageName));
                    this.resourceRenderer.renderFile(request, response, resourceFile);
                }
            } else {
                response.sendError(403, "User not Authorized");
            }
        }
        catch (UnauthorizedAccessException e) {
            response.sendError(403, "User not Authorized");
        }
        catch (Exception e) {
            this.handleException(pageName, e);
        }
    }

    private boolean isPageRequest(List<String> pathSegments) {
        if (pathSegments.size() == 1) {
            return true;
        }
        if (pathSegments.size() == 2) {
            return this.isAnIndexSegment(pathSegments.get(1));
        }
        return false;
    }

    private boolean isAnIndexSegment(String segment) {
        return segment.equalsIgnoreCase("index.html") || segment.equalsIgnoreCase("Index.groovy") || segment.equalsIgnoreCase("index");
    }

    private boolean isPageUrlWithoutFinalSlash(HttpServletRequest request) {
        return request.getPathInfo() == null || request.getPathInfo().matches("/[^/]+");
    }

    private File getResourceFile(String resourcePath, String pageName) throws IOException, BonitaException {
        PageResourceProviderImpl pageResourceProvider = this.pageRenderer.getPageResourceProvider(pageName);
        File resourceFile = new File(pageResourceProvider.getPageDirectory(), "resources" + File.separator + this.getResourcePathWithoutPageName(resourcePath, pageName));
        if (!this.bonitaHomeFolderAccessor.isInFolder(resourceFile, pageResourceProvider.getPageDirectory())) {
            throw new UnauthorizedAccessException("Unauthorized access to the file " + resourcePath);
        }
        return resourceFile;
    }

    private String getResourcePathWithoutPageName(String resourcePath, String pageName) {
        return resourcePath.substring(pageName.length() + 2);
    }

    private boolean isAuthorized(APISession apiSession, String appToken) throws BonitaException {
        return apiSession.isTechnicalUser() || this.getCustomPageAuthorizationsHelper(apiSession).isAuthorized(appToken);
    }

    private void handleException(String pageName, Exception e) throws ServletException {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Error while trying to render the custom page {}", (Object)pageName, (Object)e);
        }
        throw new ServletException(e.getMessage());
    }

    protected ApplicationAuthorizationsHelper getCustomPageAuthorizationsHelper(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return new ApplicationAuthorizationsHelper(apiSession, new ApplicationModelFactory(TenantAPIAccessor.getLivingApplicationAPI((APISession)apiSession), TenantAPIAccessor.getCustomPageAPI((APISession)apiSession), TenantAPIAccessor.getProfileAPI((APISession)apiSession)));
    }
}

