/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.page.CustomPageService;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.page.extension.PageContextImpl;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.extension.page.PageContext;
import org.bonitasoft.web.extension.page.PageController;
import org.bonitasoft.web.extension.page.PageResourceProvider;
import org.codehaus.groovy.control.CompilationFailedException;

public class PageRenderer {
    public static final String PROFILE_PARAM = "profile";
    protected CustomPageService customPageService = new CustomPageService();
    protected ResourceRenderer resourceRenderer;

    public PageRenderer(ResourceRenderer resourceRenderer) {
        this.resourceRenderer = resourceRenderer;
    }

    public void displayCustomPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, String pageName) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException, BonitaException {
        PageResourceProviderImpl pageResourceProvider = this.getPageResourceProvider(pageName);
        this.displayCustomPage(request, response, apiSession, pageResourceProvider, this.getCurrentLocale(request));
    }

    public void displayCustomPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, long pageId) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException, BonitaException {
        this.displayCustomPage(request, response, apiSession, this.getPageResourceProvider(pageId, apiSession), this.getCurrentLocale(request));
    }

    public void displayCustomPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, long pageId, Locale currentLocale) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException, BonitaException {
        this.displayCustomPage(request, response, apiSession, this.getPageResourceProvider(pageId, apiSession), currentLocale);
    }

    public void ensurePageFolderIsPresent(APISession apiSession, PageResourceProviderImpl pageResourceProvider) throws BonitaException, IOException {
        this.customPageService.ensurePageFolderIsPresent(apiSession, pageResourceProvider);
    }

    private void displayCustomPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, PageResourceProviderImpl pageResourceProvider, Locale currentLocale) throws BonitaException, IOException, InstantiationException, IllegalAccessException {
        this.customPageService.ensurePageFolderIsUpToDate(apiSession, pageResourceProvider);
        this.enforceLocaleCookieIfPresentInURLOrBrowser(request, response, currentLocale);
        if (this.isGroovyPage(pageResourceProvider)) {
            this.displayGroovyPage(request, response, apiSession, pageResourceProvider);
        } else {
            this.displaySimpleHtmlPage(request, response, pageResourceProvider);
        }
    }

    private boolean isGroovyPage(PageResourceProviderImpl pageResourceProvider) {
        File pageFolder = pageResourceProvider.getPageDirectory();
        File indexGroovy = this.customPageService.getGroovyPageFile(pageFolder);
        return indexGroovy.exists();
    }

    private void displaySimpleHtmlPage(HttpServletRequest request, HttpServletResponse response, PageResourceProviderImpl pageResourceProvider) throws IOException, BonitaException, IllegalAccessException {
        File resourceFile = this.getIndexFile(pageResourceProvider);
        this.resourceRenderer.renderFile(request, response, resourceFile, true);
    }

    private File getIndexFile(PageResourceProviderImpl pageResourceProvider) {
        File indexHtml = new File(this.getResourceFolder(pageResourceProvider), "index.html");
        if (indexHtml.exists()) {
            return indexHtml;
        }
        return new File(this.getResourceFolder(pageResourceProvider).getParent(), "index.html");
    }

    private File getResourceFolder(PageResourceProviderImpl pageResourceProvider) {
        return new File(pageResourceProvider.getPageDirectory(), "resources");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayGroovyPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, PageResourceProviderImpl pageResourceProvider) throws CompilationFailedException, InstantiationException, IllegalAccessException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        GroovyClassLoader pageClassloader = this.customPageService.getPageClassloader(apiSession, pageResourceProvider);
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)pageClassloader);
            pageResourceProvider.setResourceClassLoader((ClassLoader)pageClassloader);
            Class<?> pageClass = this.customPageService.registerPage(pageClassloader, pageResourceProvider);
            PageController pageController = (PageController)pageClass.newInstance();
            pageController.doGet(request, response, (PageResourceProvider)pageResourceProvider, (PageContext)new PageContextImpl(apiSession, this.getCurrentLocale(request), this.getCurrentProfile(request)));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    public String getCurrentProfile(HttpServletRequest request) {
        return request.getParameter(PROFILE_PARAM);
    }

    private void enforceLocaleCookieIfPresentInURLOrBrowser(HttpServletRequest request, HttpServletResponse response, Locale currentLocale) {
        String localeFromCookie = LocaleUtils.getStandardizedLocaleFromCookie(request);
        if (currentLocale != null && !currentLocale.toString().equals(localeFromCookie)) {
            LocaleUtils.addOrReplaceLocaleCookieResponse(response, currentLocale.toString());
        }
    }

    public Locale getCurrentLocale(HttpServletRequest request) {
        return LocaleUtils.getUserLocale(request);
    }

    public PageResourceProviderImpl getPageResourceProvider(String pageName) {
        return new PageResourceProviderImpl(pageName);
    }

    public PageResourceProviderImpl getPageResourceProvider(long pageId, APISession apiSession) throws BonitaException {
        Page page = this.customPageService.getPage(apiSession, pageId);
        return new PageResourceProviderImpl(page);
    }
}

