/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.bonitasoft.console.common.server.page.CustomPageRequestModifier;
import org.bonitasoft.console.common.server.page.PageMappingService;
import org.bonitasoft.console.common.server.page.PageReference;
import org.bonitasoft.console.common.server.page.PageRenderer;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.UnauthorizedAccessException;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.livingapps.ApplicationModelFactory;
import org.bonitasoft.livingapps.exception.CreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageServlet
extends HttpServlet {
    private static final long serialVersionUID = 2789496969243916444L;
    private static Logger LOGGER = LoggerFactory.getLogger((String)PageServlet.class.getName());
    public static final String RESOURCE_PATH_SEPARATOR = "/content";
    public static final String API_PATH_SEPARATOR = "/API";
    public static final String THEME_PATH_SEPARATOR = "/theme";
    public static final String APPLICATION_PARAM = "app";
    protected CustomPageRequestModifier customPageRequestModifier = new CustomPageRequestModifier();
    protected PageMappingService pageMappingService = new PageMappingService();
    protected BonitaHomeFolderAccessor bonitaHomeFolderAccessor = new BonitaHomeFolderAccessor();
    protected ResourceRenderer resourceRenderer = new ResourceRenderer();
    protected PageRenderer pageRenderer = new PageRenderer(this.resourceRenderer);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (!pathInfo.contains("/content/") && pathInfo.indexOf("/API/") > 0) {
            String apiPath = pathInfo.substring(pathInfo.indexOf("/API/"));
            this.customPageRequestModifier.forwardIfRequestIsAuthorized(request, response, API_PATH_SEPARATOR, apiPath);
        } else {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        APISession apiSession = (APISession)session.getAttribute("apiSession");
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith(RESOURCE_PATH_SEPARATOR)) {
            this.customPageRequestModifier.redirectToValidPageUrl(request, response);
        } else if (pathInfo.indexOf("/content/") > 0) {
            String[] pathInfoSegments = pathInfo.split("/content/", 2);
            String resourcePath = this.getResourcePath(pathInfoSegments);
            String mappingKey = pathInfoSegments[0].substring(1);
            try {
                this.resolveAndDisplayPage(request, response, apiSession, mappingKey, resourcePath);
            }
            catch (Exception e) {
                this.handleException(request, response, mappingKey, this.isNotResourcePath(resourcePath), e);
            }
        } else if (pathInfo.indexOf("/theme/") > 0) {
            String[] pathInfoSegments = pathInfo.split("/theme/", 2);
            String resourcePath = this.getResourcePath(pathInfoSegments);
            String mappingKey = pathInfoSegments[0].substring(1);
            try {
                this.renderThemeResource(request, response, apiSession, resourcePath);
            }
            catch (Exception e) {
                this.handleException(request, response, mappingKey, false, e);
            }
        } else {
            String message = "/content or /theme is expected in the URL after the page mapping key";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Bad request: /content or /theme is expected in the URL after the page mapping key");
            }
            response.sendError(400, "/content or /theme is expected in the URL after the page mapping key");
        }
    }

    protected void renderThemeResource(HttpServletRequest request, HttpServletResponse response, APISession apiSession, String resourcePath) throws BonitaException, CreationException, IllegalAccessException, IOException, ServletException {
        String appToken = request.getParameter(APPLICATION_PARAM);
        if (appToken != null) {
            this.renderThemeResource(request, response, apiSession, resourcePath, appToken);
        } else {
            String appTokenFromReferer = this.getAppFromReferer(request);
            if (appTokenFromReferer != null) {
                if (resourcePath.endsWith(".css")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("App parameter retrieved from the referer. Redirecting the request to get it in the URL for resource " + resourcePath);
                    }
                    String queryString = StringUtils.isEmpty((CharSequence)request.getQueryString()) ? "" : request.getQueryString() + "&";
                    response.sendRedirect("?" + queryString + "app=" + appTokenFromReferer);
                } else {
                    this.renderThemeResource(request, response, apiSession, resourcePath, appTokenFromReferer);
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable tor retrieve app parameter for resource " + resourcePath + ". Request referer is missing an an app parameter. Forwarding to the portal theme.");
                }
                String themePath = "/theme/" + resourcePath;
                this.customPageRequestModifier.forwardIfRequestIsAuthorized(request, response, THEME_PATH_SEPARATOR, themePath);
            }
        }
    }

    protected void renderThemeResource(HttpServletRequest request, HttpServletResponse response, APISession apiSession, String resourcePath, String appToken) throws BonitaException, CreationException, IllegalAccessException, IOException {
        Long themeId = this.getThemeId(apiSession, appToken);
        this.resourceRenderer.renderFile(request, response, this.getResourceFile(response, apiSession, themeId, resourcePath));
    }

    protected String getResourcePath(String[] pathInfoSegments) {
        String resourcePath = null;
        if (pathInfoSegments.length > 1 && !pathInfoSegments[1].isEmpty()) {
            resourcePath = pathInfoSegments[1];
        }
        return resourcePath;
    }

    protected String getAppFromReferer(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        if (referer != null) {
            List paramList;
            block6: {
                paramList = null;
                try {
                    paramList = URLEncodedUtils.parse((URI)new URI(referer), (String)"UTF-8");
                }
                catch (URISyntaxException e) {
                    if (!LOGGER.isWarnEnabled()) break block6;
                    LOGGER.warn("Unable tor retrieve app parameter. Bad request referer: " + e.getMessage());
                }
            }
            for (NameValuePair param : paramList) {
                if (!APPLICATION_PARAM.equalsIgnoreCase(param.getName())) continue;
                return param.getValue();
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unable tor retrieve app parameter. Request referer is null.");
        }
        return null;
    }

    protected Long getThemeId(APISession apiSession, String appToken) throws BonitaException, CreationException {
        ApplicationModelFactory applicationModelFactory = new ApplicationModelFactory(TenantAPIAccessor.getLivingApplicationAPI((APISession)apiSession), TenantAPIAccessor.getCustomPageAPI((APISession)apiSession), TenantAPIAccessor.getProfileAPI((APISession)apiSession));
        return applicationModelFactory.createApplicationModel(appToken).getApplicationThemeId();
    }

    protected void resolveAndDisplayPage(HttpServletRequest request, HttpServletResponse response, APISession apiSession, String mappingKey, String resourcePath) throws BonitaException, IOException, InstantiationException, IllegalAccessException {
        boolean isNotResourcePath = this.isNotResourcePath(resourcePath);
        try {
            Locale currentLocale = this.pageRenderer.getCurrentLocale(request);
            PageReference pageReference = this.pageMappingService.getPage(request, apiSession, mappingKey, currentLocale, isNotResourcePath);
            if (pageReference.getURL() != null) {
                this.displayExternalPage(response, pageReference.getURL());
            } else if (pageReference.getPageId() != null) {
                this.displayPageOrResource(request, response, apiSession, pageReference.getPageId(), resourcePath, currentLocale);
            } else if (LOGGER.isDebugEnabled()) {
                String message = "Both URL and pageId are not set in the page mapping for " + mappingKey;
                LOGGER.debug(message);
            }
        }
        catch (UnauthorizedAccessException e) {
            String message = "User not Authorized";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Forbidden: User not Authorized", (Throwable)e);
            }
            if (isNotResourcePath) {
                response.sendError(403, "User not Authorized");
            } else {
                response.setStatus(403);
                response.flushBuffer();
            }
        }
        catch (NotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not found: Cannot find the form mapping for key " + mappingKey, (Throwable)e);
            }
            if (isNotResourcePath) {
                response.sendError(404, "Form mapping not found");
            }
            response.setStatus(404);
            response.flushBuffer();
        }
    }

    protected void displayPageOrResource(HttpServletRequest request, HttpServletResponse response, APISession apiSession, Long pageId, String resourcePath, Locale currentLocale) throws InstantiationException, IllegalAccessException, IOException, BonitaException {
        boolean isNotResourcePath = this.isNotResourcePath(resourcePath);
        try {
            if (isNotResourcePath) {
                this.pageRenderer.displayCustomPage(request, response, apiSession, pageId, currentLocale);
            } else {
                this.resourceRenderer.renderFile(request, response, this.getResourceFile(response, apiSession, pageId, resourcePath));
            }
        }
        catch (PageNotFoundException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot find the page with ID " + pageId);
            }
            if (isNotResourcePath) {
                response.sendError(404, "Page not found");
            }
            response.setStatus(404);
            response.flushBuffer();
        }
    }

    private boolean isNotResourcePath(String resourcePath) {
        return resourcePath == null || "index.html".equals(resourcePath) || "Index.groovy".equals(resourcePath) || "index".equals(resourcePath);
    }

    protected File getResourceFile(HttpServletResponse response, APISession apiSession, Long pageId, String resourcePath) throws IOException, BonitaException {
        PageResourceProviderImpl pageResourceProvider = this.pageRenderer.getPageResourceProvider(pageId, apiSession);
        File resourceFile = pageResourceProvider.getResourceAsFile("resources" + File.separator + resourcePath);
        if (!this.bonitaHomeFolderAccessor.isInFolder(resourceFile, pageResourceProvider.getPageDirectory())) {
            String message = "For security reasons, access to this file path is forbidden : " + resourcePath;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Forbidden: " + message);
            }
            response.setStatus(403);
            response.flushBuffer();
        }
        this.pageRenderer.ensurePageFolderIsPresent(apiSession, pageResourceProvider);
        return resourceFile;
    }

    protected void displayExternalPage(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(response.encodeRedirectURL(url));
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, String mappingKey, boolean isNotResourcePath, Exception e) throws ServletException, IOException {
        if (e instanceof IllegalArgumentException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The parameters passed to the servlet are invalid.", (Throwable)e);
            }
            if (isNotResourcePath) {
                response.sendError(400, "Invalid Request.");
            } else {
                response.setStatus(400);
                response.flushBuffer();
            }
        } else if (e instanceof InvalidSessionException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalid Bonita engine session.", (Throwable)e);
            }
            SessionUtil.sessionLogout(request.getSession());
            if (isNotResourcePath) {
                response.sendError(401, "Invalid Bonita engine session.");
            } else {
                response.setStatus(401);
                response.flushBuffer();
            }
        } else {
            if (LOGGER.isWarnEnabled()) {
                String message = "Error while trying to display a page or resource for key " + mappingKey;
                LOGGER.warn(message, (Throwable)e);
            }
            if (!response.isCommitted()) {
                if (isNotResourcePath) {
                    response.sendError(500, e.getMessage());
                } else {
                    response.setStatus(500);
                    response.flushBuffer();
                }
            } else {
                throw new IOException("The response is already commited.", e);
            }
        }
    }
}

