/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.bonitasoft.console.common.server.preferences.properties.ConfigurationFilesManager;

public class SecurityProperties {
    public static final String SECURITY_DEFAULT_CONFIG_FILE_NAME = "security-config.properties";
    public static final String PASSWORD_VALIDATOR_CLASSNAME = "security.password.validator";
    public static final String CSRF_PROTECTION = "security.csrf.enabled";
    public static final String SANITIZER_PROTECTION = "security.sanitizer.enabled";
    public static final String SANITIZER_PROTECTION_EXCLUSIONS = "security.sanitizer.exclude";
    public static final List<String> DEFAULT_SANITIZER_PROTECTION_EXCLUSIONS = List.of("email", "password", "password_confirm");
    public static final String SECURE_TOKEN_COOKIE = "security.csrf.cookie.secure";
    public static final String X_FRAME_OPTIONS_HEADER = "bonita.runtime.security.csrf.header.frame.options";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "bonita.runtime.security.csrf.header.content.security.policy";
    public static final String API_AUTHORIZATIONS_CHECK = "security.rest.api.authorizations.check.enabled";
    private static final Map<String, Optional<String>> securityProperties = new ConcurrentHashMap<String, Optional<String>>();

    public String getPasswordValidator() {
        return this.getTenantProperty(PASSWORD_VALIDATOR_CLASSNAME);
    }

    public boolean isAPIAuthorizationsCheckEnabled() {
        String res = this.getTenantProperty(API_AUTHORIZATIONS_CHECK);
        return res != null && res.equals("true");
    }

    public boolean isCSRFProtectionEnabled() {
        String res = this.getPlatformProperty(CSRF_PROTECTION);
        return res != null && res.equals("true");
    }

    public boolean isSanitizerProtectionEnabled() {
        String res = this.getPlatformProperty(SANITIZER_PROTECTION);
        return !"false".equalsIgnoreCase(res);
    }

    public List<String> getAttributeExcludedFromSanitizerProtection() {
        String excludedAttributes = this.getPlatformProperty(SANITIZER_PROTECTION_EXCLUSIONS);
        if (excludedAttributes == null) {
            return DEFAULT_SANITIZER_PROTECTION_EXCLUSIONS;
        }
        if (excludedAttributes.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.asList(excludedAttributes.trim().split("\\s*,\\s*"));
    }

    public boolean isCSRFTokenCookieSecure() {
        String res = this.getPlatformProperty(SECURE_TOKEN_COOKIE);
        return res != null && res.equals("true");
    }

    public String getXFrameOptionsHeader() {
        return this.getPlatformProperty(X_FRAME_OPTIONS_HEADER);
    }

    public String getContentSecurityPolicyHeader() {
        return this.getPlatformProperty(CONTENT_SECURITY_POLICY_HEADER);
    }

    protected ConfigurationFilesManager getConfigurationFilesManager() {
        return ConfigurationFilesManager.getInstance();
    }

    public String getTenantProperty(String propertyName) {
        Properties tenantProperties = this.getConfigurationFilesManager().getTenantProperties(SECURITY_DEFAULT_CONFIG_FILE_NAME);
        Optional<String> propertyValue = securityProperties.get(propertyName);
        if (propertyValue == null) {
            propertyValue = Optional.ofNullable(tenantProperties.getProperty(propertyName));
            securityProperties.put(propertyName, propertyValue);
        }
        return propertyValue.orElse(null);
    }

    public String getPlatformProperty(String propertyName) {
        Properties platformProperties = this.getConfigurationFilesManager().getPlatformProperties(SECURITY_DEFAULT_CONFIG_FILE_NAME);
        Optional<String> propertyValue = securityProperties.get(propertyName);
        if (propertyValue == null) {
            propertyValue = Optional.ofNullable(platformProperties.getProperty(propertyName));
            securityProperties.put(propertyName, propertyValue);
        }
        return propertyValue.orElse(null);
    }
}

