/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.utils.PlatformManagementUtils;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPageServlet
extends HttpServlet {
    private static final long serialVersionUID = -6981838056314293935L;
    protected static final String ERROR_TEMPLATE_PATH = "/WEB-INF/errors.html";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ErrorPageServlet.class.getName());
    private static String errorPageString = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        response.setContentType("text/html");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        try (PrintWriter output = response.getWriter();){
            if (!StringUtils.isEmpty((CharSequence)pathInfo)) {
                APISession apiSession;
                String errorCode = pathInfo.substring(1);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Displaying error page with code " + errorCode);
                }
                if ((apiSession = (APISession)request.getSession().getAttribute("apiSession")) != null && this.isPlatformHealthy()) {
                    String contextPath = request.getContextPath();
                    if (contextPath.equals("/")) {
                        contextPath = "";
                    }
                    if (errorPageString == null) {
                        ServletContext sc = this.getServletContext();
                        try (InputStream errorPageInputStream = sc.getResourceAsStream(ERROR_TEMPLATE_PATH);){
                            errorPageString = new String(errorPageInputStream.readAllBytes(), StandardCharsets.UTF_8);
                        }
                        catch (Exception e) {
                            if (LOGGER.isErrorEnabled()) {
                                LOGGER.error("Error while trying to get the error page.", (Throwable)e);
                            }
                            output.println("An Error occurred.");
                        }
                    }
                    this.writeFormatedResponse(output, errorCode, contextPath);
                } else {
                    this.getServletContext().getRequestDispatcher("/" + errorCode + ".jsp").forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Status code missing from request.");
                }
                output.println("Status code missing from request.");
            }
            output.flush();
        }
    }

    protected boolean isPlatformHealthy() {
        try {
            PlatformManagementUtils platformManagementUtils = new PlatformManagementUtils();
            return platformManagementUtils.isPlatformAvailable();
        }
        catch (Exception e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Platform is not healthy.");
            }
            return false;
        }
    }

    protected void writeFormatedResponse(PrintWriter output, String errorCode, String contextPath) throws IOException {
        try {
            output.format(errorPageString, errorCode, contextPath, errorCode);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while trying to display the error page.", (Throwable)e);
            }
            output.println("An Error occurred.");
        }
    }
}

