/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.exception.ExportException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;

abstract class BonitaExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1800666571090128789L;

    BonitaExportServlet() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = null;
        try {
            byte[] resourceBytes = this.exportResources(request);
            this.setResponseHeaders(request, response);
            out = response.getOutputStream();
            out.write(resourceBytes);
        }
        catch (InvalidSessionException e) {
            String message = "Session expired. Please log in again.";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message, (Throwable)e);
            }
            response.sendError(401, message);
        }
        catch (FileNotFoundException e) {
            String message = "There is no BDM Access control installed.";
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(message);
            }
            response.sendError(404, message);
        }
        catch (Exception e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream");
        String encodedfileName = URLEncoder.encode(this.getFileExportName(), StandardCharsets.UTF_8);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.contains("Firefox")) {
            response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedfileName);
        } else {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedfileName.replaceAll("\\_", " ") + "\"; filename*=UTF-8''" + encodedfileName);
        }
    }

    protected abstract String getFileExportName();

    protected abstract byte[] exportResources(HttpServletRequest var1) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, ExportException, FileNotFoundException, ExecutionException;

    protected abstract Logger getLogger();
}

