/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationNotFoundException;
import org.bonitasoft.engine.business.application.IApplication;
import org.bonitasoft.livingapps.ApplicationModel;
import org.bonitasoft.livingapps.exception.CreationException;
import org.bonitasoft.livingapps.menu.MenuFactory;

public class ApplicationModelFactory {
    private final ApplicationAPI applicationApi;
    private final PageAPI customPageApi;
    private final ProfileAPI profileApi;

    public ApplicationModelFactory(ApplicationAPI applicationApi, PageAPI customPageApi, ProfileAPI profileApi) {
        this.applicationApi = applicationApi;
        this.customPageApi = customPageApi;
        this.profileApi = profileApi;
    }

    public ApplicationModel createApplicationModel(String applicationToken) throws CreationException {
        try {
            IApplication application = this.applicationApi.getIApplicationByToken(applicationToken);
            if (!(application instanceof Application)) {
                throw new CreationException("Only application links were found with name " + applicationToken);
            }
            return new ApplicationModel(this.applicationApi, this.customPageApi, this.profileApi, (Application)application, new MenuFactory(this.applicationApi));
        }
        catch (ApplicationNotFoundException e) {
            throw new CreationException("Error while searching for the application " + applicationToken, e);
        }
    }
}

