/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.page.ApplicationAuthorizationsHelper;
import org.bonitasoft.console.common.server.page.CustomPageRequestModifier;
import org.bonitasoft.console.common.server.page.PageRenderer;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.page.extension.PageResourceProviderImpl;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.livingapps.ApplicationModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivingApplicationPageServlet
extends HttpServlet {
    public static final String RESOURCE_PATH_SEPARATOR = "/content";
    public static final String API_PATH_SEPARATOR = "/API";
    public static final String THEME_PATH_SEPARATOR = "/theme";
    private static final long serialVersionUID = -5410859017103815654L;
    private static Logger LOGGER = LoggerFactory.getLogger((String)LivingApplicationPageServlet.class.getName());
    protected ResourceRenderer resourceRenderer = new ResourceRenderer();
    protected PageRenderer pageRenderer = new PageRenderer(this.resourceRenderer);
    protected BonitaHomeFolderAccessor bonitaHomeFolderAccessor = new BonitaHomeFolderAccessor();
    protected CustomPageRequestModifier customPageRequestModifier = new CustomPageRequestModifier();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        List<String> pathSegments = this.resourceRenderer.getPathSegments(pathInfo);
        if (this.isValidPathForToken(API_PATH_SEPARATOR, pathSegments)) {
            String apiPath = pathInfo.substring(pathInfo.indexOf("/API/"));
            this.customPageRequestModifier.forwardIfRequestIsAuthorized(request, response, API_PATH_SEPARATOR, apiPath);
        } else {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block18: {
            String pathInfo = request.getPathInfo();
            HttpSession session = request.getSession();
            APISession apiSession = (APISession)session.getAttribute("apiSession");
            if (pathInfo.endsWith(RESOURCE_PATH_SEPARATOR)) {
                this.customPageRequestModifier.redirectToValidPageUrl(request, response);
                return;
            }
            String appToken = null;
            String pageToken = null;
            String customPageName = null;
            String resourcePath = null;
            List<String> pathSegments = this.resourceRenderer.getPathSegments(pathInfo);
            if (pathSegments.size() >= 3) {
                appToken = pathSegments.get(0);
                pageToken = pathSegments.get(1);
                if (this.isValidPathForToken(RESOURCE_PATH_SEPARATOR, pathSegments)) {
                    boolean isNotResourcePath;
                    String pageMapping = "/" + appToken + "/" + pageToken + "/content/";
                    if (pathInfo.length() > pageMapping.length()) {
                        resourcePath = pathInfo.substring(pageMapping.length());
                    }
                    if (StringUtils.isBlank((CharSequence)(customPageName = this.getCustomPageName(appToken, pageToken, apiSession, request, response, isNotResourcePath = this.isNotResourcePath(resourcePath))))) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Error while trying to retrieve the application page");
                        }
                        return;
                    }
                    try {
                        if (this.isAuthorized(apiSession, appToken, customPageName)) {
                            if (isNotResourcePath) {
                                this.pageRenderer.displayCustomPage(request, response, apiSession, customPageName);
                            } else {
                                File resourceFile = this.getResourceFile(resourcePath, customPageName);
                                this.pageRenderer.ensurePageFolderIsPresent(apiSession, this.pageRenderer.getPageResourceProvider(customPageName));
                                this.resourceRenderer.renderFile(request, response, resourceFile);
                            }
                            break block18;
                        }
                        if (isNotResourcePath) {
                            response.sendError(403, "User not Authorized");
                            break block18;
                        }
                        response.setStatus(403);
                        response.flushBuffer();
                    }
                    catch (Exception e) {
                        this.handleException(customPageName, e, request, response, isNotResourcePath);
                    }
                } else if (this.isValidPathForToken(THEME_PATH_SEPARATOR, pathSegments)) {
                    String themeResourcePath = pathInfo.substring(pathInfo.indexOf("/theme/"));
                    String appThemeResourcePrefix = "/apps/" + appToken;
                    this.customPageRequestModifier.forwardIfRequestIsAuthorized(request, response, appThemeResourcePrefix + "/theme/", appThemeResourcePrefix + themeResourcePath);
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("One of the separator '/content', '/theme' or '/API' is expected in the URL after the application token and the page token.");
                    }
                    response.setStatus(400);
                    response.flushBuffer();
                }
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("The info path is suppose to contain the application token, the page token and one of the separator '/content', '/theme' or '/API'.");
                }
                response.setStatus(400);
                response.flushBuffer();
            }
        }
    }

    private String getCustomPageName(String appToken, String pageToken, APISession apiSession, HttpServletRequest request, HttpServletResponse response, boolean isNotResourcePath) throws ServletException, IOException {
        try {
            Long customPageId = this.getApplicationApi(apiSession).getApplicationPage(appToken, pageToken).getPageId();
            return this.getPageApi(apiSession).getPage(customPageId.longValue()).getName();
        }
        catch (NotFoundException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The application page " + appToken + "/" + pageToken + " was not found.");
            }
            if (isNotResourcePath) {
                response.sendError(404, "Cannot find the page" + pageToken + "for the application" + appToken + ".");
            } else {
                response.setStatus(404);
                response.flushBuffer();
            }
        }
        catch (Exception e) {
            this.handleException(appToken + "/" + pageToken, e, request, response, isNotResourcePath);
        }
        return "";
    }

    private boolean isValidPathForToken(String TokenSeparator, List<String> pathSegments) {
        return pathSegments.size() > 2 && pathSegments.get(2).equals(TokenSeparator.substring(1));
    }

    private boolean isNotResourcePath(String resourcePath) {
        return resourcePath == null || "index.html".equals(resourcePath) || "Index.groovy".equals(resourcePath) || "index".equals(resourcePath);
    }

    private File getResourceFile(String resourcePath, String pageName) throws IOException, BonitaException {
        PageResourceProviderImpl pageResourceProvider = this.pageRenderer.getPageResourceProvider(pageName);
        File resourceFile = new File(pageResourceProvider.getPageDirectory(), "resources" + File.separator + resourcePath);
        if (!this.bonitaHomeFolderAccessor.isInFolder(resourceFile, pageResourceProvider.getPageDirectory())) {
            throw new BonitaException("Unauthorized access to the file " + resourcePath);
        }
        return resourceFile;
    }

    private boolean isAuthorized(APISession apiSession, String appToken, String pageName) throws BonitaException {
        return this.getCustomPageAuthorizationsHelper(apiSession).isAuthorized(appToken);
    }

    private void handleException(String pageName, Exception e, HttpServletRequest request, HttpServletResponse response, boolean isNotResourcePath) throws ServletException, IOException {
        if (e instanceof InvalidSessionException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalid Bonita engine session.", (Throwable)e);
            }
            SessionUtil.sessionLogout(request.getSession());
            if (isNotResourcePath) {
                response.sendError(401, "Invalid Bonita engine session.");
            } else {
                response.setStatus(401);
                response.flushBuffer();
            }
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error while trying to render the application page " + pageName, (Throwable)e);
            }
            throw new ServletException(e.getMessage());
        }
    }

    protected ApplicationAPI getApplicationApi(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getLivingApplicationAPI((APISession)apiSession);
    }

    protected PageAPI getPageApi(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getCustomPageAPI((APISession)apiSession);
    }

    protected ApplicationAuthorizationsHelper getCustomPageAuthorizationsHelper(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return new ApplicationAuthorizationsHelper(apiSession, new ApplicationModelFactory(TenantAPIAccessor.getLivingApplicationAPI((APISession)apiSession), TenantAPIAccessor.getCustomPageAPI((APISession)apiSession), TenantAPIAccessor.getProfileAPI((APISession)apiSession)));
    }
}

