/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.model.bpm.process;

import java.util.Date;
import org.bonitasoft.web.rest.model.bpm.process.ProcessDefinition;
import org.bonitasoft.web.rest.model.identity.UserItem;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;
import org.bonitasoft.web.toolkit.client.data.item.Item;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasDualName;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasLastUpdateDate;
import org.bonitasoft.web.toolkit.client.data.item.template.ItemHasUniqueId;

public class ProcessItem
extends Item
implements ItemHasUniqueId,
ItemHasLastUpdateDate,
ItemHasDualName {
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_DEPLOYMENT_DATE = "deploymentDate";
    public static final String ATTRIBUTE_DEPLOYED_BY_USER_ID = "deployedBy";
    public static final String ATTRIBUTE_ACTIVATION_STATE = "activationState";
    public static final String ATTRIBUTE_CONFIGURATION_STATE = "configurationState";
    public static final String ATTRIBUTE_DISPLAY_DESCRIPTION = "displayDescription";
    public static final String ATTRIBUTE_ACTOR_INITIATOR_ID = "actorinitiatorid";
    public static final String VALUE_ACTIVATION_STATE_DISABLED = "DISABLED";
    public static final String VALUE_ACTIVATION_STATE_ENABLED = "ENABLED";
    public static final String VALUE_CONFIGURATION_STATE_UNRESOLVED = "UNRESOLVED";
    public static final String VALUE_CONFIGURATION_STATE_RESOLVED = "RESOLVED";
    public static final String FILTER_TEAM_MANAGER_ID = "team_manager_id";
    public static final String FILTER_SUPERVISOR_ID = "supervisor_id";
    public static final String FILTER_USER_ID = "user_id";
    public static final String FILTER_RECENT_PROCESSES = "recentProcesses";
    public static final String FILTER_CATEGORY_ID = "categoryId";
    public static final String FILTER_FOR_PENDING_OR_ASSIGNED_TASKS = "forPendingOrAssignedTask";
    public static final String COUNTER_FAILED_CASES = "failedCases";
    public static final String COUNTER_OPEN_CASES = "openCases";

    public ProcessItem() {
    }

    public ProcessItem(IItem item) {
        super(item);
    }

    @Override
    public String getName() {
        return this.getAttributeValue("name");
    }

    public String getVersion() {
        return this.getAttributeValue(ATTRIBUTE_VERSION);
    }

    public String ensureName() {
        if (StringUtil.isBlank(this.getDisplayName())) {
            return this.getName();
        }
        return this.getDisplayName();
    }

    public String getDescription() {
        return this.getAttributeValue(ATTRIBUTE_DESCRIPTION);
    }

    public String getDeploymentDate() {
        return this.getAttributeValue(ATTRIBUTE_DEPLOYMENT_DATE);
    }

    public APIID getDeployedByUserId() {
        return APIID.makeAPIID(this.getAttributeValue(ATTRIBUTE_DEPLOYED_BY_USER_ID));
    }

    public String getActivationState() {
        return this.getAttributeValue(ATTRIBUTE_ACTIVATION_STATE);
    }

    public String getConfigurationState() {
        return this.getAttributeValue(ATTRIBUTE_CONFIGURATION_STATE);
    }

    @Override
    public String getDisplayName() {
        return this.getAttributeValue("displayName");
    }

    public String getDisplayDescription() {
        return this.getAttributeValue(ATTRIBUTE_DISPLAY_DESCRIPTION);
    }

    @Override
    public Date getLastUpdateDate() {
        return this.getAttributeValueAsDate("last_update_date");
    }

    public String getActorInitiatorId() {
        return this.getAttributeValue(ATTRIBUTE_ACTOR_INITIATOR_ID);
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    @Override
    public void setId(Long id) {
        this.setId(id.toString());
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setVersion(String version) {
        this.setAttribute(ATTRIBUTE_VERSION, version);
    }

    public void setDescription(String description) {
        this.setAttribute(ATTRIBUTE_DESCRIPTION, description);
    }

    public void setDeployedByUserId(String id) {
        this.setAttribute(ATTRIBUTE_DEPLOYED_BY_USER_ID, id);
    }

    public void setDeployedByUserId(Long id) {
        this.setDeployedByUserId(id.toString());
    }

    public void setDeployedByUserId(APIID id) {
        this.setAttribute(ATTRIBUTE_DEPLOYED_BY_USER_ID, id);
    }

    public void setDeploymentDate(String date) {
        this.setAttribute(ATTRIBUTE_DEPLOYMENT_DATE, date);
    }

    public void setDeploymentDate(Date date) {
        this.setAttribute(ATTRIBUTE_DEPLOYMENT_DATE, date);
    }

    public void setActivationState(String state) {
        this.setAttribute(ATTRIBUTE_ACTIVATION_STATE, state);
    }

    public void setConfigurationState(String state) {
        this.setAttribute(ATTRIBUTE_CONFIGURATION_STATE, state);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public void setDisplayDescription(String displayDescription) {
        this.setAttribute(ATTRIBUTE_DISPLAY_DESCRIPTION, displayDescription);
    }

    @Override
    public void setLastUpdateDate(String date) {
        this.setAttribute("last_update_date", date);
    }

    @Override
    public void setLastUpdateDate(Date date) {
        this.setAttribute("last_update_date", date);
    }

    public void setActorInitiatorId(Long id) {
        this.setActorInitiatorId(id.toString());
    }

    public void setActorInitiatorId(APIID id) {
        this.setActorInitiatorId(id.toString());
    }

    public void setActorInitiatorId(String id) {
        this.setAttribute(ATTRIBUTE_ACTOR_INITIATOR_ID, id);
    }

    public UserItem getDeployedByUser() {
        return new UserItem(this.getDeploy(ATTRIBUTE_DEPLOYED_BY_USER_ID));
    }

    public boolean isEnabled() {
        return VALUE_ACTIVATION_STATE_ENABLED.equals(this.getActivationState());
    }

    public boolean isResolved() {
        return VALUE_CONFIGURATION_STATE_RESOLVED.equals(this.getConfigurationState());
    }

    public boolean isStartable() {
        return this.isEnabled() && this.isResolved();
    }

    public ItemDefinition<ProcessItem> getItemDefinition() {
        return ProcessDefinition.get();
    }
}

