/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.ModelFactory;
import org.bonitasoft.web.rest.server.BonitaRestAPIFactory;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeConverter;
import org.bonitasoft.web.rest.server.framework.RestAPIFactory;
import org.bonitasoft.web.rest.server.framework.servlet.APIServlet;
import org.bonitasoft.web.toolkit.client.ItemDefinitionFactory;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;

public class BonitaRestAPIServlet
extends APIServlet {
    private static final long serialVersionUID = 525945083859596909L;

    public BonitaRestAPIServlet() {
        FlowNodeConverter.setFlowNodeConverter(new FlowNodeConverter());
    }

    @Override
    protected ItemDefinitionFactory defineApplicatioFactoryCommon() {
        return new ModelFactory();
    }

    @Override
    protected RestAPIFactory defineApplicatioFactoryServer() {
        return new BonitaRestAPIFactory();
    }

    @Override
    protected void catchAllExceptions(Throwable exception, HttpServletRequest req, HttpServletResponse resp) {
        resp.setCharacterEncoding("UTF-8");
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            super.catchAllExceptions(e, req, resp);
        }
        if (exception instanceof InvalidSessionException || exception instanceof APIException && exception.getCause() != null && exception.getCause() instanceof InvalidSessionException) {
            HttpServletRequestAccessor requestAccessor = new HttpServletRequestAccessor(req);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(exception.getMessage(), exception);
            }
            this.outputException(exception, req, resp, 401);
            SessionUtil.sessionLogout(requestAccessor.getHttpSession());
        } else if (exception.getCause() instanceof NotFoundException) {
            this.outputException(null, req, resp, 404);
        } else if (exception instanceof TenantStatusException) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Platform is probably under Maintenance : " + exception.getMessage());
            }
            this.outputException(null, req, resp, 503);
        } else {
            super.catchAllExceptions(exception, req, resp);
        }
    }
}

