/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server;

import java.util.List;
import java.util.logging.Level;
import org.bonitasoft.web.rest.server.FinderFactory;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferenceResource;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferencesResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseContextResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariablesResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.CaseContextResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.ActivityVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.TimerEventTriggerResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContextResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContractResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskExecutionResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedActivityVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedUserTaskContextResource;
import org.bonitasoft.web.rest.server.api.bpm.message.BPMMessageResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessContractResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessDefinitionDesignResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessInstantiationResource;
import org.bonitasoft.web.rest.server.api.bpm.signal.BPMSignalResource;
import org.bonitasoft.web.rest.server.api.form.FormMappingResource;
import org.bonitasoft.web.rest.server.api.system.I18nTranslationResource;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.ext.jackson.JacksonConverter;
import org.restlet.routing.Router;

public class BonitaRestletApplication
extends Application {
    public static final String ROUTER_EXTENSION_PREFIX = "/extension/";
    public static final String BDM_BUSINESS_DATA_URL = "/bdm/businessData";
    public static final String BDM_BUSINESS_DATA_REFERENCE_URL = "/bdm/businessDataReference";
    public static final String FORM_MAPPING_URL = "/form/mapping";
    public static final String BPM_PROCESS_URL = "/bpm/process";
    public static final String BPM_USER_TASK_URL = "/bpm/userTask";
    public static final String BPM_ARCHIVED_USER_TASK_URL = "/bpm/archivedUserTask";
    public static final String BPM_TIMER_EVENT_TRIGGER_URL = "/bpm/timerEventTrigger";
    public static final String BPM_MESSAGE_URL = "/bpm/message";
    public static final String BPM_SIGNAL_URL = "/bpm/signal";
    public static final String BPM_ACTIVITY_VARIABLE_URL = "/bpm/activityVariable";
    public static final String BPM_CASE_CONTEXT_URL = "/bpm/case";
    private static final String BPM_ARCHIVED_CASE_CONTEXT_URL = "/bpm/archivedCase";
    public static final String BPM_ARCHIVED_CASE_VARIABLE_URL = "/bpm/archivedCaseVariable";
    public static final String BPM_ARCHIVED_ACTIVITY_VARIABLE_URL = "/bpm/archivedActivityVariable";
    private final FinderFactory factory;

    public BonitaRestletApplication(FinderFactory finderFactory, ConverterHelper converterHelper) {
        this.factory = finderFactory;
        this.getMetadataService().setDefaultMediaType(MediaType.APPLICATION_JSON);
        this.getMetadataService().setDefaultCharacterSet(CharacterSet.UTF_8);
        this.replaceJacksonConverter(converterHelper);
    }

    private void replaceJacksonConverter(ConverterHelper converterHelper) {
        List registeredConverters = Engine.getInstance().getRegisteredConverters();
        registeredConverters.add(converterHelper);
        for (ConverterHelper registeredConverter : registeredConverters) {
            if (!registeredConverter.getClass().equals(JacksonConverter.class)) continue;
            registeredConverters.remove(registeredConverter);
            registeredConverters.add(converterHelper);
        }
    }

    public synchronized Restlet createInboundRoot() {
        return this.buildRouter();
    }

    protected Router buildRouter() {
        Context context = this.getContext();
        Router router = new Router(context);
        router.attach("/bpm/activityVariable/{activityid}/{dataname}", (Restlet)this.factory.create(ActivityVariableResource.class));
        router.attach(BPM_TIMER_EVENT_TRIGGER_URL, (Restlet)this.factory.create(TimerEventTriggerResource.class));
        router.attach("/bpm/timerEventTrigger/{id}", (Restlet)this.factory.create(TimerEventTriggerResource.class));
        router.attach(BPM_MESSAGE_URL, (Restlet)this.factory.create(BPMMessageResource.class));
        router.attach(BPM_SIGNAL_URL, (Restlet)this.factory.create(BPMSignalResource.class));
        router.attach("/bpm/case/{caseId}/context", (Restlet)this.factory.create(CaseContextResource.class));
        router.attach("/bpm/archivedCase/{archivedCaseId}/context", (Restlet)this.factory.create(ArchivedCaseContextResource.class));
        router.attach("/bpm/userTask/{taskId}/contract", (Restlet)this.factory.create(UserTaskContractResource.class));
        router.attach("/bpm/userTask/{taskId}/execution", (Restlet)this.factory.create(UserTaskExecutionResource.class));
        router.attach("/bpm/userTask/{taskId}/context", (Restlet)this.factory.create(UserTaskContextResource.class));
        router.attach("/bpm/archivedUserTask/{archivedTaskId}/context", (Restlet)this.factory.create(ArchivedUserTaskContextResource.class));
        router.attach("/bpm/process/{processDefinitionId}/design", (Restlet)this.factory.create(ProcessDefinitionDesignResource.class));
        router.attach("/bpm/process/{processDefinitionId}/contract", (Restlet)this.factory.create(ProcessContractResource.class));
        router.attach("/bpm/process/{processDefinitionId}/instantiation", (Restlet)this.factory.create(ProcessInstantiationResource.class));
        router.attach(FORM_MAPPING_URL, (Restlet)this.factory.create(FormMappingResource.class));
        router.attach(BDM_BUSINESS_DATA_REFERENCE_URL, (Restlet)this.factory.create(BusinessDataReferencesResource.class));
        router.attach("/bdm/businessDataReference/{caseId}/{dataName}", (Restlet)this.factory.create(BusinessDataReferenceResource.class));
        router.attach(ROUTER_EXTENSION_PREFIX, (Restlet)this.factory.createExtensionResource(), 1);
        router.attach("/system/i18ntranslation", (Restlet)this.factory.create(I18nTranslationResource.class));
        router.attach("/bpm/archivedCaseVariable/{caseId}/{variableName}", (Restlet)this.factory.create(ArchivedCaseVariableResource.class));
        router.attach(BPM_ARCHIVED_CASE_VARIABLE_URL, (Restlet)this.factory.create(ArchivedCaseVariablesResource.class));
        router.attach("/bpm/archivedActivityVariable/{activityId}/{variableName}", (Restlet)this.factory.create(ArchivedActivityVariableResource.class));
        return router;
    }

    public void handle(Request request, Response response) {
        request.setLoggable(false);
        Engine.setLogLevel((Level)Level.OFF);
        Engine.setRestletLogLevel((Level)Level.OFF);
        super.handle(request, response);
    }
}

