/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.server.ApiExtensionResourceFinder;
import org.bonitasoft.web.rest.server.ResourceFinder;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferenceResource;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferenceResourceFinder;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferencesResource;
import org.bonitasoft.web.rest.server.api.bdm.BusinessDataReferencesResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseContextResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseContextResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariableResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariablesResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.ArchivedCaseVariablesResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.cases.CaseContextResource;
import org.bonitasoft.web.rest.server.api.bpm.cases.CaseContextResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.ActivityVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.ActivityVariableResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.TimerEventTriggerResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.TimerEventTriggerResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContextResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContextResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContractResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskContractResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskExecutionResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.UserTaskExecutionResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedActivityVariableResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedActivityVariableResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedUserTaskContextResource;
import org.bonitasoft.web.rest.server.api.bpm.flownode.archive.ArchivedUserTaskContextResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.message.BPMMessageResource;
import org.bonitasoft.web.rest.server.api.bpm.message.BPMMessageResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessContractResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessContractResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessDefinitionDesignResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessDefinitionDesignResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessInstantiationResource;
import org.bonitasoft.web.rest.server.api.bpm.process.ProcessInstantiationResourceFinder;
import org.bonitasoft.web.rest.server.api.bpm.signal.BPMSignalResource;
import org.bonitasoft.web.rest.server.api.bpm.signal.BPMSignalResourceFinder;
import org.bonitasoft.web.rest.server.api.form.FormMappingResource;
import org.bonitasoft.web.rest.server.api.form.FormMappingResourceFinder;
import org.bonitasoft.web.rest.server.api.system.I18nTanslationResourceFinder;
import org.bonitasoft.web.rest.server.api.system.I18nTranslationResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;

public class FinderFactory {
    protected final Map<Class<? extends ServerResource>, ResourceFinder> finders;
    final List<ResourceFinder> resourceFinders = new ArrayList<ResourceFinder>();

    public FinderFactory() {
        this.finders = this.getDefaultFinders();
        this.createResourceFinderList(this.finders);
    }

    public FinderFactory(Map<Class<? extends ServerResource>, ResourceFinder> finders) {
        this.finders = finders;
        this.createResourceFinderList(finders);
    }

    private void createResourceFinderList(Map<Class<? extends ServerResource>, ResourceFinder> finders) {
        for (Map.Entry<Class<? extends ServerResource>, ResourceFinder> classFinderEntry : finders.entrySet()) {
            ResourceFinder resourceFinder = classFinderEntry.getValue();
            this.resourceFinders.add(resourceFinder);
            resourceFinder.setFinderFactory(this);
        }
    }

    protected Map<Class<? extends ServerResource>, ResourceFinder> getDefaultFinders() {
        HashMap<Class<? extends ServerResource>, ResourceFinder> finders = new HashMap<Class<? extends ServerResource>, ResourceFinder>();
        finders.put(ActivityVariableResource.class, new ActivityVariableResourceFinder());
        finders.put(TimerEventTriggerResource.class, new TimerEventTriggerResourceFinder());
        finders.put(BPMMessageResource.class, new BPMMessageResourceFinder());
        finders.put(BPMSignalResource.class, new BPMSignalResourceFinder());
        finders.put(CaseContextResource.class, new CaseContextResourceFinder());
        finders.put(ArchivedCaseContextResource.class, new ArchivedCaseContextResourceFinder());
        finders.put(BusinessDataReferenceResource.class, new BusinessDataReferenceResourceFinder());
        finders.put(BusinessDataReferencesResource.class, new BusinessDataReferencesResourceFinder());
        finders.put(FormMappingResource.class, new FormMappingResourceFinder());
        finders.put(UserTaskContractResource.class, new UserTaskContractResourceFinder());
        finders.put(UserTaskExecutionResource.class, new UserTaskExecutionResourceFinder());
        finders.put(UserTaskContextResource.class, new UserTaskContextResourceFinder());
        finders.put(ArchivedUserTaskContextResource.class, new ArchivedUserTaskContextResourceFinder());
        finders.put(ProcessContractResource.class, new ProcessContractResourceFinder());
        finders.put(ProcessDefinitionDesignResource.class, new ProcessDefinitionDesignResourceFinder());
        finders.put(ProcessInstantiationResource.class, new ProcessInstantiationResourceFinder());
        finders.put(I18nTranslationResource.class, new I18nTanslationResourceFinder());
        finders.put(ArchivedCaseVariableResource.class, new ArchivedCaseVariableResourceFinder());
        finders.put(ArchivedCaseVariablesResource.class, new ArchivedCaseVariablesResourceFinder());
        finders.put(ArchivedActivityVariableResource.class, new ArchivedActivityVariableResourceFinder());
        return finders;
    }

    public Finder create(Class<? extends ServerResource> clazz) {
        Finder finder = this.finders.get(clazz);
        if (finder == null) {
            throw new RuntimeException("Finder unimplemented for class " + String.valueOf(clazz));
        }
        return finder;
    }

    public Finder createExtensionResource() {
        return new ApiExtensionResourceFinder();
    }

    public ResourceFinder getResourceFinderFor(Serializable object) {
        for (ResourceFinder resourceFinder : this.resourceFinders) {
            if (!resourceFinder.handlesResource(object)) continue;
            return resourceFinder;
        }
        return null;
    }

    public Serializable getContextResultElement(Serializable object) {
        ResourceFinder resourceFinderFor = this.getResourceFinderFor(object);
        if (resourceFinderFor != null) {
            return resourceFinderFor.toClientObject(object);
        }
        return object;
    }
}

