/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.business.data.BusinessDataCrudOperationException;
import org.bonitasoft.engine.business.data.InvalidBusinessDataModelException;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.exception.UnavailableLockException;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.server.api.SpringResponseEntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class SpringRestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringRestResponseEntityExceptionHandler.class);
    private static final Map<String, String> parameterErrorNames = Map.of("c", "count", "p", "page");

    @ExceptionHandler(value={TenantStatusException.class})
    protected ResponseEntity<Object> handleMaintenanceMode(RuntimeException ex, WebRequest request) {
        return this.handleExceptionInternal(ex, "Platform under maintenance", new HttpHeaders(), HttpStatus.SERVICE_UNAVAILABLE, request);
    }

    @ExceptionHandler(value={InvalidSessionException.class})
    protected ResponseEntity<Object> handleInvalidSession(RuntimeException ex, WebRequest request, HttpSession httpSession) {
        SessionUtil.sessionLogout(httpSession);
        return this.handleExceptionInternal(ex, "Invalid session", new HttpHeaders(), HttpStatus.UNAUTHORIZED, request);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> defaultToInternalServerError(Exception exception) {
        log.error("Generic server-side error", (Throwable)exception);
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException(exception, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<Object> handleMaxSizeException(MaxUploadSizeExceededException ex) {
        return SpringResponseEntityUtils.generateErrorResponse(ex.getClass().getName(), HttpStatus.BAD_REQUEST, this.getRootCause((Throwable)ex).getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Object> handleIllegalArgumentException(IllegalArgumentException e) {
        return SpringResponseEntityUtils.generateErrorResponse(e.getClass().getName(), HttpStatus.BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<Object> handleInvalidParameters(HttpServletRequest req, MethodArgumentTypeMismatchException ex) {
        boolean isNumber;
        String mapping;
        String parameterName = ex.getName();
        if (log.isDebugEnabled()) {
            log.debug("Invalid parameter [{}] {}: {}", new Object[]{req.getPathInfo(), parameterName, ex.getMessage()});
        }
        if ((mapping = parameterErrorNames.get(parameterName)) != null) {
            return SpringRestResponseEntityExceptionHandler.bonitaHandleException(new IllegalArgumentException("query parameter " + parameterName + " (" + mapping + ") should be a number"), HttpStatus.BAD_REQUEST);
        }
        Object value = ex.getValue();
        Class requiredType = ex.getRequiredType();
        boolean bl = isNumber = Integer.class.equals((Object)requiredType) || Long.class.equals((Object)requiredType);
        if (isNumber) {
            return SpringRestResponseEntityExceptionHandler.bonitaHandleException(new IllegalArgumentException("[ " + String.valueOf(value) + " ] must be a number"), HttpStatus.BAD_REQUEST);
        }
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException(new IllegalArgumentException("Bad parameter " + parameterName + "=" + String.valueOf(value)), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<Object> handleNotFound(NotFoundException exception) {
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException(exception, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={CommandExecutionException.class})
    public ResponseEntity<Object> handleExecutionException(CommandExecutionException exception) {
        Throwable wrapped = exception.getCause();
        Throwable causedByIsDataNotFoundException = this.getFirstCauseOfType(wrapped, NotFoundException.class);
        if (causedByIsDataNotFoundException != null) {
            return SpringRestResponseEntityExceptionHandler.bonitaHandleException(causedByIsDataNotFoundException, HttpStatus.NOT_FOUND);
        }
        Throwable causedByBusinessDataCrudOperationException = this.getFirstCauseOfType(wrapped, BusinessDataCrudOperationException.class);
        if (causedByBusinessDataCrudOperationException != null) {
            return SpringResponseEntityUtils.generateErrorResponse(causedByBusinessDataCrudOperationException.getClass().getName(), HttpStatus.BAD_REQUEST, causedByBusinessDataCrudOperationException.getMessage());
        }
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException((Throwable)exception, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={InvalidBusinessDataModelException.class})
    public ResponseEntity<Object> handleInvalidBDM(InvalidBusinessDataModelException exception) {
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException((Throwable)exception, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    protected ResponseEntity<Object> handleUnavailableLockException(UndeclaredThrowableException exception) {
        UnavailableLockException unavailableLockException = (UnavailableLockException)this.getFirstCauseOfType(exception, UnavailableLockException.class);
        if (unavailableLockException != null) {
            return SpringResponseEntityUtils.generateErrorResponse(unavailableLockException.getClass().getName(), HttpStatus.NOT_ACCEPTABLE, unavailableLockException.getMessage());
        }
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException(exception, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private <T extends Throwable> Throwable getFirstCauseOfType(Throwable exception, Class<T> exceptionTypeToSearch) {
        if (exception == null) {
            return null;
        }
        if (exceptionTypeToSearch.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return this.getFirstCauseOfType(exception.getCause(), exceptionTypeToSearch);
    }

    private <T extends Throwable> Throwable getRootCause(Throwable exception) {
        if (exception == null) {
            return null;
        }
        Throwable cause = exception.getCause();
        if (cause == null || cause == exception) {
            return exception;
        }
        return this.getRootCause(cause);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException exception, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String parameterName = exception.getParameterName();
        String mapping = parameterErrorNames.get(parameterName);
        String message = mapping != null ? "query parameter " + parameterName + " (" + mapping + ") is mandatory" : "query parameter " + parameterName + " is mandatory";
        return SpringRestResponseEntityExceptionHandler.bonitaHandleException(new IllegalArgumentException(message), HttpStatus.BAD_REQUEST);
    }

    private static ResponseEntity<Object> bonitaHandleException(Throwable exception, HttpStatus status) {
        Throwable cause = exception.getCause() != null ? exception.getCause() : exception;
        return SpringResponseEntityUtils.generateErrorResponse(exception.getClass().getName(), status, cause.getMessage());
    }
}

