/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.business.data.BusinessDataRepositoryDeploymentException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bdm.BusinessDataModelItem;
import org.bonitasoft.web.rest.server.api.AbstractRESTController;
import org.bonitasoft.web.rest.server.api.SpringResponseEntityUtils;
import org.bonitasoft.web.rest.server.api.tenant.TenantResourceItem;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/API/tenant/bdm"}, produces={"application/json"})
public class BusinessDataModelController
extends AbstractRESTController {
    @PostMapping(consumes={"application/json"})
    @Deprecated(since="9.0.0")
    public TenantResourceItem installOrUpdateBDM(@RequestBody BusinessDataModelItem businessDataModelItem, HttpSession httpSession) throws BonitaException {
        TenantAdministrationAPI tenantAdministrationAPI = this.getTenantAdministrationAPI(httpSession);
        if (!tenantAdministrationAPI.isPaused()) {
            throw new TenantStatusException("Unable to install the Business Data Model. Please pause the BPM Services first. Go to Configuration > BPM Services.");
        }
        try {
            FileContent businessDataModel = this.getBusinessDataModel(businessDataModelItem);
            byte[] businessDataModelContent = this.getBusinessDataModelContent(businessDataModel.getInputStream());
            tenantAdministrationAPI.updateBusinessDataModel(businessDataModelContent);
            TenantResourceItem tenantResourceItem = new TenantResourceItem(tenantAdministrationAPI.getBusinessDataModelResource(), businessDataModel.getFileName());
            return tenantResourceItem;
        }
        catch (BusinessDataRepositoryDeploymentException e) {
            throw new APIException("An error has occurred when deploying Business Data Model.", (Throwable)e);
        }
        finally {
            this.getBonitaHomeFolderAccessor().removeUploadedTempContent(businessDataModelItem.getFileUpload());
        }
    }

    @ExceptionHandler(value={APIForbiddenException.class, TenantStatusException.class})
    protected ResponseEntity<Object> handleAPIForbidden(Exception ex) {
        return SpringResponseEntityUtils.generateErrorResponse(ex, HttpStatus.FORBIDDEN);
    }

    @GetMapping
    public TenantResourceItem getBDM(HttpSession httpSession) {
        try {
            return new TenantResourceItem(this.getTenantAdministrationAPI(httpSession).getBusinessDataModelResource());
        }
        catch (TenantStatusException | InvalidSessionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
    }

    protected FileContent getBusinessDataModel(BusinessDataModelItem item) {
        try {
            return this.getBonitaHomeFolderAccessor().retrieveUploadedTempContent(item.getFileUpload());
        }
        catch (BonitaException e) {
            throw new APIException("Can't read business data model file", (Throwable)e);
        }
    }

    private byte[] getBusinessDataModelContent(InputStream inputStream) {
        byte[] byArray;
        block8: {
            InputStream inputStream2 = inputStream;
            try {
                byArray = IOUtils.toByteArray((InputStream)inputStream);
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new APIException("Can't read business data model file", (Throwable)e);
                }
            }
            inputStream2.close();
        }
        return byArray;
    }

    protected BonitaHomeFolderAccessor getBonitaHomeFolderAccessor() {
        return new BonitaHomeFolderAccessor();
    }
}

