/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import java.util.List;
import java.util.Map;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.ArchivedCaseDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIArchivedCase
extends ConsoleAPI<ArchivedCaseItem>
implements APIHasGet<ArchivedCaseItem>,
APIHasSearch<ArchivedCaseItem>,
APIHasDelete {
    @Override
    public ItemDefinition defineItemDefinition() {
        return Definitions.get("archivedcases");
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new ArchivedCaseDatastore(this.getEngineSession());
    }

    @Override
    public ArchivedCaseItem get(APIID id) {
        return this.getArchivedCaseDatastore().get(id);
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "";
    }

    @Override
    public ItemSearchResult<ArchivedCaseItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("team_manager_id") && filters.containsKey("supervisor_id")) {
            throw new APIException("Can't set those filters at the same time : team_manager_id and supervisor_id");
        }
        return this.getArchivedCaseDatastore().search(page, resultsByPage, search, orders, filters);
    }

    @Override
    protected void fillDeploys(ArchivedCaseItem item, List<String> deploys) {
        if (this.isDeployable("started_by", deploys, item)) {
            item.setDeploy("started_by", this.getUserDatastore().get(item.getStartedByUserId()));
        }
        if (this.isDeployable("startedBySubstitute", deploys, item)) {
            item.setDeploy("startedBySubstitute", this.getUserDatastore().get(item.getStartedBySubstituteUserId()));
        }
        if (this.isDeployable("processDefinitionId", deploys, item)) {
            item.setDeploy("processDefinitionId", this.getProcessDatastore().get(item.getProcessId()));
        }
    }

    protected ProcessDatastore getProcessDatastore() {
        return new ProcessDatastore(this.getEngineSession());
    }

    protected UserDatastore getUserDatastore() {
        return new UserDatastore(this.getEngineSession());
    }

    @Override
    protected void fillCounters(ArchivedCaseItem item, List<String> counters) {
    }

    protected ArchivedCaseDatastore getArchivedCaseDatastore() {
        return new ArchivedCaseDatastore(this.getEngineSession());
    }
}

