/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode.archive;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.flownode.UserTaskNotFoundException;
import org.bonitasoft.engine.expression.ExpressionEvaluationException;
import org.bonitasoft.web.rest.server.FinderFactory;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Get;

public class ArchivedUserTaskContextResource
extends CommonResource {
    static final String ARCHIVED_TASK_ID = "archivedTaskId";
    private final ProcessAPI processAPI;
    private final FinderFactory resourceHandler;

    public ArchivedUserTaskContextResource(ProcessAPI processAPI, FinderFactory resourceHandler) {
        this.processAPI = processAPI;
        this.resourceHandler = resourceHandler;
    }

    @Get(value="json")
    public Map<String, Serializable> getArchivedUserTaskContext() throws UserTaskNotFoundException, ExpressionEvaluationException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        Map archivedUserTaskExecutionContext = this.processAPI.getArchivedUserTaskExecutionContext(this.getArchivedTaskIdParameter());
        for (Map.Entry executionContextElement : archivedUserTaskExecutionContext.entrySet()) {
            resultMap.put((String)executionContextElement.getKey(), this.getContextResultElement((Serializable)executionContextElement.getValue()));
        }
        return resultMap;
    }

    private Serializable getContextResultElement(Serializable executionContextElementValue) {
        return this.resourceHandler.getContextResultElement(executionContextElementValue);
    }

    protected long getArchivedTaskIdParameter() {
        String taskId = this.getAttribute(ARCHIVED_TASK_ID);
        if (taskId == null) {
            throw new APIException("Attribute 'archivedTaskId' is mandatory in order to get the archived task context");
        }
        return Long.parseLong(taskId);
    }
}

