/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.message;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.flownode.SendEventException;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.ExpressionBuilder;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.InvalidExpressionException;
import org.bonitasoft.web.rest.server.api.bpm.message.BPMMessage;
import org.bonitasoft.web.rest.server.api.bpm.message.BPMMessageValue;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Post;

public class BPMMessageResource
extends CommonResource {
    private static final Set<String> SUPPORTED_TYPES = new HashSet<String>();
    private final ProcessAPI processAPI;

    public BPMMessageResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Post(value="json")
    public void sendMessage(BPMMessage message) {
        this.validateMandatoryAttributes(message);
        try {
            HashMap<Expression, Expression> msgContent = new HashMap<Expression, Expression>();
            if (message.getMessageContent() != null) {
                for (Map.Entry<String, BPMMessageValue> entry : message.getMessageContent().entrySet()) {
                    msgContent.put(new ExpressionBuilder().createConstantStringExpression(entry.getKey()), this.getExpressionFromObject(entry));
                }
            }
            HashMap<Expression, Expression> correlations = new HashMap<Expression, Expression>();
            if (message.getCorrelations() != null) {
                int nbCorrelations = message.getCorrelations().size();
                if (nbCorrelations > 5) {
                    throw new IllegalArgumentException(String.format("A maximum of 5 correlations is supported. %s found.", nbCorrelations));
                }
                for (Map.Entry<String, BPMMessageValue> entry : message.getCorrelations().entrySet()) {
                    correlations.put(new ExpressionBuilder().createConstantStringExpression(entry.getKey()), this.getExpressionFromObject(entry));
                }
            }
            Expression targetFlowNodeExpression = null;
            if (message.getTargetFlowNode() != null) {
                targetFlowNodeExpression = new ExpressionBuilder().createConstantStringExpression(message.getTargetFlowNode());
            }
            this.processAPI.sendMessage(message.getMessageName(), new ExpressionBuilder().createConstantStringExpression(message.getTargetProcess()), targetFlowNodeExpression, msgContent, correlations);
        }
        catch (SendEventException | InvalidExpressionException e) {
            throw new APIException(e);
        }
    }

    private Expression getExpressionFromObject(Map.Entry<String, BPMMessageValue> entry) throws InvalidExpressionException {
        BPMMessageValue messageValue = entry.getValue();
        if (messageValue == null) {
            throw new IllegalArgumentException(String.format("%s value cannot be null.", entry.getKey()));
        }
        Object value = messageValue.getValue();
        if (value == null) {
            throw new IllegalArgumentException(String.format("%s value cannot be null.", entry.getKey()));
        }
        String type = this.valueType(messageValue.getType(), value);
        if (!this.isSupportedType(type)) {
            throw new InvalidExpressionException(String.format("BPM send message: unsupported value type '%s' for key '%s'. Only primitive types are supported.", messageValue.getType(), entry.getKey()));
        }
        String stringValue = String.valueOf(value);
        String expressionName = stringValue.trim().isEmpty() ? "empty-value" : stringValue;
        return new ExpressionBuilder().createExpression(expressionName, stringValue, this.valueType(type, value), ExpressionType.TYPE_CONSTANT);
    }

    private String valueType(String type, Object value) {
        if (type != null) {
            return type;
        }
        return this.guessType(value);
    }

    private String guessType(Object value) {
        if (value instanceof String) {
            try {
                LocalDate.parse((String)value);
                return LocalDate.class.getName();
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    LocalDateTime.parse((String)value);
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    // empty catch block
                }
                try {
                    OffsetDateTime.parse((String)value);
                    return OffsetDateTime.class.getName();
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    return String.class.getName();
                }
            }
        }
        if (value instanceof Long) {
            return Long.class.getName();
        }
        if (value instanceof Double) {
            return Double.class.getName();
        }
        if (value instanceof Float) {
            return Float.class.getName();
        }
        if (value instanceof Integer) {
            return Integer.class.getName();
        }
        if (value instanceof Boolean) {
            return Boolean.class.getName();
        }
        return null;
    }

    private boolean isSupportedType(String type) {
        return SUPPORTED_TYPES.contains(type);
    }

    private void validateMandatoryAttributes(BPMMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message body is missing");
        }
        if (message.getMessageName() == null) {
            throw new IllegalArgumentException("messageName is mandatory");
        }
        if (message.getTargetProcess() == null) {
            throw new IllegalArgumentException("targetProcess is mandatory");
        }
    }

    static {
        SUPPORTED_TYPES.add(String.class.getName());
        SUPPORTED_TYPES.add(Integer.class.getName());
        SUPPORTED_TYPES.add(Long.class.getName());
        SUPPORTED_TYPES.add(Float.class.getName());
        SUPPORTED_TYPES.add(Double.class.getName());
        SUPPORTED_TYPES.add(Boolean.class.getName());
        SUPPORTED_TYPES.add(Date.class.getName());
        SUPPORTED_TYPES.add(LocalDate.class.getName());
        SUPPORTED_TYPES.add(LocalDateTime.class.getName());
        SUPPORTED_TYPES.add(OffsetDateTime.class.getName());
    }
}

