/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.process;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.ContractTypeConverter;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.contract.ContractDefinition;
import org.bonitasoft.engine.bpm.contract.ContractViolationException;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstantiationResource
extends CommonResource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessInstantiationResource.class.getName());
    private static final String CASE_ID_ATTRIBUTE = "caseId";
    static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String USER_PARAM = "user";
    private final ProcessAPI processAPI;
    protected ContractTypeConverter typeConverterUtil = new ContractTypeConverter(ContractTypeConverter.ISO_8601_DATE_PATTERNS);

    public ProcessInstantiationResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
    }

    @Post(value="json")
    public String instantiateProcess(Map<String, Serializable> inputs) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException, FileNotFoundException {
        String userId = this.getRequestParameter(USER_PARAM);
        long processDefinitionId = this.getProcessDefinitionIdParameter();
        try {
            ContractDefinition processContract = this.processAPI.getProcessContract(processDefinitionId);
            long maxSizeForTenant = PropertiesFactory.getConsoleProperties().getMaxSize();
            Map<String, Serializable> processedInputs = this.typeConverterUtil.getProcessedInput(processContract, inputs, maxSizeForTenant);
            long processInstanceId = userId == null ? this.processAPI.startProcessWithInputs(processDefinitionId, processedInputs).getId() : this.processAPI.startProcessWithInputs(Long.parseLong(userId), processDefinitionId, processedInputs).getId();
            this.typeConverterUtil.deleteTemporaryFiles(inputs);
            JsonNodeFactory factory = JsonNodeFactory.instance;
            ObjectNode returnedObject = factory.objectNode();
            returnedObject.put(CASE_ID_ATTRIBUTE, processInstanceId);
            return returnedObject.toString();
        }
        catch (ProcessExecutionException e) {
            String errorMessage = "Unable to start the process with ID " + processDefinitionId;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("{}. Caused by: {}", (Object)errorMessage, (Object)e.getMessage());
            }
            if (e.getRetryAfter() != -1L) {
                Response response = this.getResponse();
                response.setRetryAfter(new Date(e.getRetryAfter()));
                Status status = new Status(Status.CLIENT_ERROR_TOO_MANY_REQUESTS, "Case creation limit reached.", errorMessage);
                response.setStatus(status);
                return null;
            }
            throw new ProcessExecutionException(errorMessage + " (consult the logs for more information).");
        }
        catch (ContractViolationException e) {
            this.manageContractViolationException(e, "Cannot instantiate process.");
            return null;
        }
    }

    protected long getProcessDefinitionIdParameter() {
        String processDefinitionId = this.getAttribute(PROCESS_DEFINITION_ID);
        if (processDefinitionId == null) {
            throw new APIException("Attribute 'processDefinitionId' is mandatory");
        }
        return Long.parseLong(processDefinitionId);
    }
}

