/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.deployer;

import org.bonitasoft.web.rest.server.framework.Deployer;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class GenericDeployer<I extends IItem>
implements Deployer {
    private final DatastoreHasGet<I> getter;
    private final String attribute;

    public GenericDeployer(DatastoreHasGet<I> getter, String attribute) {
        this.getter = getter;
        this.attribute = attribute;
    }

    @Override
    public String getDeployedAttribute() {
        return this.attribute;
    }

    @Override
    public void deployIn(IItem item) {
        if (this.isDeployable(this.attribute, item)) {
            item.setDeploy(this.attribute, (IItem)this.getItem(this.getItemId(item)));
        }
    }

    private APIID getItemId(IItem item) {
        return item.getAttributeValueAsAPIID(this.attribute);
    }

    private I getItem(APIID profileId) {
        return this.getter.get(profileId);
    }
}

