/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.document.ArchivedDocumentItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.document.api.impl.DocumentDatastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIArchivedDocument
extends ConsoleAPI<ArchivedDocumentItem> {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("archivedDocument");
    }

    @Override
    public ArchivedDocumentItem get(APIID id) {
        APISession apiSession = this.getEngineSession();
        ArchivedDocumentItem item = new ArchivedDocumentItem();
        try {
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)apiSession);
            DocumentDatastore dataStore = new DocumentDatastore(apiSession);
            ArchivedDocument document = processAPI.getArchivedProcessDocument(id.toLong().longValue());
            item = dataStore.mapToArchivedDocumentItem(document);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
        return item;
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "";
    }

    @Override
    public ItemSearchResult<ArchivedDocumentItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        APISession apiSession = this.getEngineSession();
        ArrayList<ArchivedDocumentItem> items = new ArrayList<ArchivedDocumentItem>();
        long nbOfDocument = 0L;
        String caseId = null;
        String viewType = null;
        String documentName = null;
        long userId = -1L;
        try {
            if (filters.containsKey("CASE_ID")) {
                caseId = filters.get("CASE_ID");
            }
            if (filters.containsKey("VIEW")) {
                viewType = filters.get("VIEW");
            }
            if (filters.containsKey("USER_ID")) {
                String user = filters.get("USER_ID");
                userId = user != null ? Long.valueOf(user).longValue() : apiSession.getUserId();
            }
            if (filters.containsKey("documentName")) {
                documentName = filters.get("documentName");
            }
            SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
            if (caseId != null) {
                builder.filter("processinstanceid", (Serializable)((Object)caseId));
            }
            if (documentName != null) {
                builder.filter("documentName", (Serializable)((Object)documentName));
            }
            SearchResult<ArchivedDocument> result = null;
            DocumentDatastore dataStore = new DocumentDatastore(apiSession);
            if (userId != -1L && viewType != null) {
                result = dataStore.searchArchivedDocuments(userId, viewType, builder);
            }
            if (result != null) {
                nbOfDocument = result.getCount();
                for (ArchivedDocument document : result.getResult()) {
                    items.add(dataStore.mapToArchivedDocumentItem(document));
                }
            }
        }
        catch (IllegalArgumentException | BonitaException e) {
            throw new APIException(e);
        }
        return new ItemSearchResult<ArchivedDocumentItem>(page, resultsByPage, nbOfDocument, items);
    }

    @Override
    protected void fillDeploys(ArchivedDocumentItem item, List<String> deploys) {
    }

    @Override
    protected void fillCounters(ArchivedDocumentItem item, List<String> counters) {
    }
}

