/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.document.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;

public class DocumentUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getArrayByte(InputStream input, int estimatedSize) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(estimatedSize);){
            int len;
            byte[] buf = new byte[8192];
            while ((len = input.read(buf)) >= 0) {
                output.write(buf, 0, len);
            }
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getArrayByteFromFile(File f) throws IOException {
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        try (FileInputStream input = new FileInputStream(f);){
            byte[] byArray = DocumentUtil.getArrayByte(input, (int)length);
            return byArray;
        }
    }

    public static String getFileNameFromUrl(String file) {
        int index;
        String fileName = null;
        if (file != null && (index = file.lastIndexOf("/")) != -1 && index != file.length() - 1) {
            String queryName = file.substring(index + 1);
            int queryIndex = queryName.indexOf("?");
            fileName = queryIndex != -1 ? queryName.substring(0, queryIndex) : queryName;
        }
        return fileName;
    }

    public static String getMimeTypeFromUrl(String fileUrl) {
        String type = null;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        type = fileNameMap.getContentTypeFor(fileUrl);
        return type;
    }
}

