/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.system;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bonitasoft.web.rest.server.api.system.VersionFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BonitaVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BonitaVersion.class.getName());
    private List<String> metadata;
    private final VersionFile versionFile;

    public BonitaVersion(VersionFile file) {
        this.versionFile = file;
    }

    private List<String> read(VersionFile versionFile) {
        List<String> result;
        block8: {
            result = new ArrayList<String>();
            try (Stream<String> lines = new BufferedReader(new InputStreamReader(versionFile.getStream())).lines();){
                result = lines.collect(Collectors.toList());
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block8;
                LOGGER.warn("Unable to read the file VERSION", (Throwable)e);
            }
        }
        return result;
    }

    public String getVersion() {
        if (this.metadata == null) {
            this.metadata = this.read(this.versionFile);
        }
        if (this.metadata.size() > 0) {
            return this.metadata.get(0).trim();
        }
        return "";
    }

    public String getBrandingVersion() {
        String brandingVersionWithDate = this.getBrandingVersionWithUpdate();
        return brandingVersionWithDate.substring(0, brandingVersionWithDate.indexOf("-"));
    }

    public String getBrandingVersionWithUpdate() {
        if (this.metadata == null) {
            this.metadata = this.read(this.versionFile);
        }
        if (this.metadata.size() > 1) {
            return this.metadata.get(1).trim();
        }
        return "";
    }

    public String getCopyright() {
        if (this.metadata == null) {
            this.metadata = this.read(this.versionFile);
        }
        if (this.metadata.size() > 2) {
            return this.metadata.get(2).trim();
        }
        return "";
    }
}

