/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.HumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.TaskPriority;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.flownode.HumanTaskItem;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.AbstractTaskDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.TaskDatastore;
import org.bonitasoft.web.rest.server.datastore.converter.ActivityAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.utils.Sort;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.ui.utils.DateFormat;

public class AbstractHumanTaskDatastore<CONSOLE_ITEM extends HumanTaskItem, ENGINE_ITEM extends HumanTaskInstance>
extends AbstractTaskDatastore<CONSOLE_ITEM, ENGINE_ITEM> {
    public AbstractHumanTaskDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected static HumanTaskItem fillConsoleItem(HumanTaskItem result, HumanTaskInstance item) {
        TaskDatastore.fillConsoleItem(result, (ActivityInstance)item);
        result.setActorId(APIID.makeAPIID(item.getActorId()));
        result.setAssignedId(APIID.makeAPIID(item.getAssigneeId()));
        result.setAssignedDate(item.getClaimedDate());
        result.setPriority(item.getPriority() != null ? item.getPriority().toString().toLowerCase() : null);
        result.setDueDate(item.getExpectedEndDate());
        return result;
    }

    @Override
    protected SearchOptionsBuilder makeSearchOptionBuilder(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        String convertedSort = null;
        if (orders != null) {
            convertedSort = new Sort(orders, new ActivityAttributeConverter()).toString();
        }
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, convertedSort, search);
        this.addStringFilterToSearchBuilder(filters, builder, "caseId", "processInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "rootCaseId", "rootProcessInstanceId");
        this.addStringFilterToSearchBuilder(filters, builder, "parentCaseId", "parentProcessInstanceId");
        if (!filters.containsKey("user_id") && !filters.containsKey("team_manager_id")) {
            this.addStringFilterToSearchBuilder(filters, builder, "processId", "processDefinitionId");
        }
        this.addStringFilterToSearchBuilder(filters, builder, "state", "state");
        this.addStringFilterToSearchBuilder(filters, builder, "type", "activityType");
        this.addStringFilterToSearchBuilder(filters, builder, "assigned_id", "assigneeId");
        this.addStringFilterToSearchBuilder(filters, builder, "priority", "priority");
        this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
        this.addStringFilterToSearchBuilder(filters, builder, "displayName", "displayName");
        return builder;
    }

    @Override
    protected SearchResult<ENGINE_ITEM> runSearch(SearchOptionsBuilder builder, Map<String, String> filters) {
        APIID id = null;
        id = APIID.makeAPIID(filters.get("supervisor_id"));
        if (id != null && id.isValidLongID()) {
            filters.remove("supervisor_id");
            return this.runSupervisorSearch(filters, builder, id.toLong());
        }
        id = APIID.makeAPIID(filters.get("team_manager_id"));
        if (id != null && id.isValidLongID()) {
            return this.runTeamManagerSearch(filters, builder, id.toLong());
        }
        return this.runGenericSearch(builder, filters);
    }

    protected SearchResult<ENGINE_ITEM> runGenericSearch(SearchOptionsBuilder builder, Map<String, String> filters) {
        try {
            APIID id = null;
            id = APIID.makeAPIID(filters.get("assigned_id"));
            if (id != null && id.isValidLongID()) {
                SearchResult searchHumanTaskInstances = this.getProcessAPI().searchPendingTasksAssignedToUser(id.toLong().longValue(), builder.done());
                return searchHumanTaskInstances;
            }
            id = APIID.makeAPIID(filters.get("user_id"));
            if (id != null && id.isValidLongID()) {
                if (filters.containsKey("show_assigned_to_others") && Boolean.parseBoolean(filters.get("show_assigned_to_others"))) {
                    SearchResult searchPendingTasks = this.getProcessAPI().searchPendingOrAssignedToUserOrAssignedToOthersTasks(id.toLong().longValue(), builder.done());
                    return searchPendingTasks;
                }
                if (filters.containsKey("assigned_id") && APIID.makeAPIID(filters.get("assigned_id")) == null) {
                    SearchResult searchPendingTasksForUser = this.getProcessAPI().searchPendingTasksForUser(id.toLong().longValue(), builder.done());
                    return searchPendingTasksForUser;
                }
                if (filters.containsKey("processId")) {
                    SearchResult searchMyAvailableHumanTasks = this.getProcessAPI().searchAssignedAndPendingHumanTasksFor(APIID.makeAPIID(filters.get("processId")).toLong().longValue(), id.toLong().longValue(), builder.done());
                    return searchMyAvailableHumanTasks;
                }
                SearchResult searchMyAvailableHumanTasks = this.getProcessAPI().searchMyAvailableHumanTasks(id.toLong().longValue(), builder.done());
                return searchMyAvailableHumanTasks;
            }
            if ("ready".equals(filters.get("state"))) {
                SearchResult searchHumanTaskInstances = this.getProcessAPI().searchAssignedAndPendingHumanTasks(builder.done());
                return searchHumanTaskInstances;
            }
            SearchResult searchHumanTaskInstances = this.getProcessAPI().searchHumanTaskInstances(builder.done());
            return searchHumanTaskInstances;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private SearchResult<ENGINE_ITEM> runTeamManagerSearch(Map<String, String> filters, SearchOptionsBuilder builder, Long teamManagerId) {
        try {
            if (filters.containsKey("is_claimed")) {
                if (Boolean.TRUE.equals(MapUtil.getValueAsBoolean(filters, "is_claimed"))) {
                    SearchResult searchResult = this.getProcessAPI().searchAssignedTasksManagedBy(teamManagerId.longValue(), builder.done());
                    return searchResult;
                }
                if (filters.containsKey("processId")) {
                    SearchResult searchMyAvailableHumanTasks = this.getProcessAPI().searchAssignedAndPendingHumanTasks(APIID.makeAPIID(filters.get("processId")).toLong().longValue(), builder.done());
                    return searchMyAvailableHumanTasks;
                }
                SearchResult searchResult = this.getProcessAPI().searchPendingTasksManagedBy(teamManagerId.longValue(), builder.done());
                return searchResult;
            }
            SearchResult searchHumanTaskInstances = this.getProcessAPI().searchHumanTaskInstances(builder.done());
            return searchHumanTaskInstances;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private SearchResult<ENGINE_ITEM> runSupervisorSearch(Map<String, String> filters, SearchOptionsBuilder builder, Long supervisorId) {
        try {
            String taskType = filters.get("state");
            if (taskType == null) {
                throw new APIException("Can't retrieve mixed state tasks for a defined supervisor");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)taskType, (CharSequence)"ready")) {
                SearchResult searchResult = this.getProcessAPI().searchPendingTasksSupervisedBy(supervisorId.longValue(), builder.done());
                return searchResult;
            }
            throw new APIException("Can't retrieve non pending human task for a Process Manager");
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public CONSOLE_ITEM get(APIID id) {
        try {
            HumanTaskInstance humanTaskInstance = this.getProcessAPI().getHumanTaskInstance(id.toLong().longValue());
            return (CONSOLE_ITEM)((HumanTaskItem)this.convertEngineToConsoleItem(humanTaskInstance));
        }
        catch (ActivityInstanceNotFoundException e) {
            throw new APIItemNotFoundException("humantask", id);
        }
    }

    @Override
    public CONSOLE_ITEM update(APIID id, Map<String, String> attributes) {
        try {
            if (attributes.containsKey("priority")) {
                this.getProcessAPI().setTaskPriority(id.toLong().longValue(), TaskPriority.valueOf((String)attributes.get("priority").toUpperCase()));
            }
            if (attributes.containsKey("dueDate")) {
                this.getProcessAPI().updateDueDateOfTask(id.toLong().longValue(), DateFormat.sqlToDate(attributes.get("dueDate")));
            }
            if (attributes.containsKey("assigned_id")) {
                APIID userId = APIID.makeAPIID(attributes.get("assigned_id"));
                if (userId == null || !userId.isValidLongID()) {
                    this.getProcessAPI().releaseUserTask(id.toLong().longValue());
                } else {
                    this.getProcessAPI().assignUserTask(id.toLong().longValue(), userId.toLong().longValue());
                }
            }
            return (CONSOLE_ITEM)((HumanTaskItem)super.update(id, (Map)attributes));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long getNumberOfOpenTasks(APIID userId) {
        return (Long)this.getProcessAPI().getNumberOfOpenTasks(Collections.singletonList(userId.toLong())).get(userId.toLong());
    }

    public Long getNumberOfOverdueOpenTasks(APIID userId) {
        return (Long)this.getProcessAPI().getNumberOfOverdueOpenTasks(Collections.singletonList(userId.toLong())).get(userId.toLong());
    }
}

