/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode;

import java.util.HashMap;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.web.rest.model.bpm.flownode.ArchivedTaskItem;
import org.bonitasoft.web.rest.model.bpm.flownode.TaskItem;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class TaskFinder {
    private final DatastoreHasGet<TaskItem> journal;
    private final DatastoreHasSearch<ArchivedTaskItem> archives;

    public TaskFinder(DatastoreHasGet<TaskItem> journal, DatastoreHasSearch<ArchivedTaskItem> archives) {
        this.journal = journal;
        this.archives = archives;
    }

    public IItem find(APIID taskId) {
        try {
            return this.journal.get(taskId);
        }
        catch (APIItemNotFoundException e) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("sourceObjectId", taskId.toString());
            ItemSearchResult<ArchivedTaskItem> result = this.archives.search(0, 1, null, "archivedDate " + String.valueOf(Order.DESC), filters);
            if (result.getResults().isEmpty()) {
                throw new APIItemNotFoundException("archivedtask", taskId);
            }
            return result.getResults().get(0);
        }
    }
}

