/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.category.Category;
import org.bonitasoft.engine.bpm.category.CategoryCriterion;
import org.bonitasoft.engine.bpm.category.CategoryNotFoundException;
import org.bonitasoft.engine.bpm.category.CategoryUpdater;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bpm.process.CategoryItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CategoryDatastore
extends CommonDatastore<CategoryItem, Category>
implements DatastoreHasSearch<CategoryItem>,
DatastoreHasGet<CategoryItem>,
DatastoreHasDelete,
DatastoreHasAdd<CategoryItem>,
DatastoreHasUpdate<CategoryItem> {
    public CategoryDatastore(APISession engineSession) {
        super(engineSession);
    }

    public long getNumberOfCategories() {
        try {
            return this.getProcessAPI().getNumberOfCategories();
        }
        catch (InvalidSessionException e) {
            throw new APIException(e);
        }
    }

    public long getNumberOfCategories(long processId) {
        return this.getProcessAPI().getNumberOfCategories(processId);
    }

    @Override
    public ItemSearchResult<CategoryItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        CategoryCriterion orderCrit = this.getOrder(orders);
        if (filters.containsKey("id")) {
            return this.searchProcessCategories(page, resultsByPage, filters, orderCrit);
        }
        return this.searchCategories(page, resultsByPage, orderCrit);
    }

    private ItemSearchResult<CategoryItem> searchCategories(int page, int resultsByPage, CategoryCriterion orderCrit) {
        List searchResult = this.getProcessAPI().getCategories(SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, orderCrit);
        return new ItemSearchResult<CategoryItem>(page, resultsByPage, this.getNumberOfCategories(), this.convertEngineToConsoleItemsList(searchResult));
    }

    private ItemSearchResult<CategoryItem> searchProcessCategories(int page, int resultsByPage, Map<String, String> filters, CategoryCriterion orderCrit) {
        Long processId = Long.valueOf(filters.get("id"));
        List searchResult = this.getProcessAPI().getCategoriesOfProcessDefinition(processId.longValue(), SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, orderCrit);
        return new ItemSearchResult<CategoryItem>(page, resultsByPage, this.getNumberOfCategories(processId), this.convertEngineToConsoleItemsList(searchResult));
    }

    private CategoryCriterion getOrder(String orders) {
        if ("name".equals(orders)) {
            return CategoryCriterion.NAME_ASC;
        }
        return CategoryCriterion.valueOf((String)orders);
    }

    @Override
    public CategoryItem add(CategoryItem item) {
        try {
            Category result = this.getProcessAPI().createCategory(item.getName(), item.getDescription());
            return this.convertEngineToConsoleItem(result);
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("Category with name %categoryName% already exists", new Arg("categoryName", item.getName())), (Throwable)e);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public CategoryItem get(APIID id) {
        try {
            Category result = this.getProcessAPI().getCategory(id.toLong().longValue());
            return this.convertEngineToConsoleItem(result);
        }
        catch (CategoryNotFoundException e) {
            throw new APIItemNotFoundException("categories", id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected CategoryItem convertEngineToConsoleItem(Category item) {
        CategoryItem categoryItem = new CategoryItem();
        categoryItem.setCreatedByUserId(item.getCreator());
        categoryItem.setCreationDate(item.getCreationDate());
        categoryItem.setDescription(item.getDescription());
        categoryItem.setDisplayName(item.getName());
        categoryItem.setId(item.getId());
        categoryItem.setName(item.getName());
        return categoryItem;
    }

    protected final CategoryUpdater createCategoryUpdater(CategoryItem item) {
        if (item == null) {
            return null;
        }
        CategoryUpdater updater = new CategoryUpdater();
        if (item.getDescription() != null) {
            updater.setDescription(item.getDescription());
        }
        return updater;
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            ProcessAPI processAPI = this.getProcessAPI();
            for (APIID id : ids) {
                Long idCat = id.toLong();
                while (processAPI.removeProcessDefinitionsFromCategory(idCat.longValue(), 0, 20) > 0L) {
                }
                processAPI.deleteCategory(idCat.longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof CategoryNotFoundException) {
                throw new APIItemNotFoundException("categories");
            }
            throw new APIException(e);
        }
    }

    @Override
    public CategoryItem update(APIID id, Map<String, String> attributes) {
        try {
            ProcessAPI processAPI = this.getProcessAPI();
            CategoryItem catItem = new CategoryItem();
            catItem.setAttributes(attributes);
            catItem.setId(id);
            processAPI.updateCategory(id.toLong().longValue(), this.createCategoryUpdater(catItem));
            return this.get(id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }
}

