/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process.helper;

import org.bonitasoft.console.common.server.utils.TenantCacheUtil;
import org.bonitasoft.console.common.server.utils.TenantCacheUtilFactory;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.actor.ActorNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.web.rest.model.bpm.process.ProcessItem;
import org.bonitasoft.web.rest.server.datastore.converter.ItemConverter;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;

public class ProcessItemConverter
extends ItemConverter<ProcessItem, ProcessDeploymentInfo> {
    private final ProcessAPI processApi;

    public ProcessItemConverter(ProcessAPI processApi) {
        this.processApi = processApi;
    }

    @Override
    public ProcessItem convert(ProcessDeploymentInfo engineItem) {
        ProcessItem item = new ProcessItem();
        item.setId(engineItem.getProcessId());
        item.setName(engineItem.getName());
        item.setVersion(engineItem.getVersion());
        item.setDescription(engineItem.getDescription());
        item.setDeployedByUserId(engineItem.getDeployedBy());
        item.setDeploymentDate(engineItem.getDeploymentDate());
        item.setActivationState(engineItem.getActivationState().name());
        item.setConfigurationState(engineItem.getConfigurationState().name());
        item.setDisplayName(engineItem.getDisplayName());
        item.setDisplayDescription(engineItem.getDisplayDescription());
        item.setLastUpdateDate(engineItem.getLastUpdateDate());
        item.setActorInitiatorId(this.getActorInitiator(engineItem));
        return item;
    }

    private Long getActorInitiator(ProcessDeploymentInfo engineItem) {
        TenantCacheUtil tenantCacheUtil = TenantCacheUtilFactory.getTenantCacheUtil();
        Long actorInitiatorId = tenantCacheUtil.getProcessActorInitiatorId(engineItem.getProcessId());
        if (actorInitiatorId == null) {
            actorInitiatorId = tenantCacheUtil.storeProcessActorInitiatorId(engineItem.getProcessId(), this.getActorInitiatorFromEngine(engineItem));
        }
        return actorInitiatorId;
    }

    private Long getActorInitiatorFromEngine(ProcessDeploymentInfo engineItem) {
        Long actorInitiatorId;
        try {
            actorInitiatorId = this.processApi.getActorInitiator(engineItem.getProcessId()).getId();
        }
        catch (ActorNotFoundException e) {
            actorInitiatorId = -1L;
        }
        catch (ProcessDefinitionNotFoundException e) {
            throw new APIException(AbstractI18n.t_("Process definition not found for id %processId%", new Arg("processId", String.valueOf(engineItem.getProcessId()))), (Throwable)e);
        }
        return actorInitiatorId;
    }
}

