/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process.helper;

import java.util.Map;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.model.bpm.process.ProcessItem;
import org.bonitasoft.web.rest.server.datastore.bpm.process.helper.ProcessItemConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.process.helper.ProcessSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.process.helper.SearchProcessFilterCreator;
import org.bonitasoft.web.rest.server.datastore.converter.ItemSearchResultConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.engineclient.ProcessEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class SearchProcessHelper
implements DatastoreHasSearch<ProcessItem> {
    private final ProcessEngineClient engineClient;

    public SearchProcessHelper(ProcessEngineClient engineClient) {
        this.engineClient = engineClient;
    }

    @Override
    public ItemSearchResult<ProcessItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator searchOptions = new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, new ProcessSearchDescriptorConverter()), new Filters(filters, new SearchProcessFilterCreator(new ProcessSearchDescriptorConverter())));
        SearchResult<ProcessDeploymentInfo> result = this.runSearch(filters, searchOptions.create());
        return this.convertResult(page, resultsByPage, result);
    }

    private SearchResult<ProcessDeploymentInfo> runSearch(Map<String, String> filters, SearchOptions searchOptions) {
        if (this.isFilteringOn(filters, "user_id", "recentProcesses")) {
            return this.engineClient.searchRecentlyStartedProcessDefinitions(this.getApiId(filters, "user_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "user_id", "categoryId") && filters.get("categoryId") == null) {
            return this.engineClient.searchUncategorizedProcessDefinitionsUserCanStart(this.getApiId(filters, "user_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "user_id", "forPendingOrAssignedTask")) {
            return this.engineClient.searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(this.getApiId(filters, "user_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "user_id")) {
            return this.engineClient.searchProcessDeploymentInfos(this.getApiId(filters, "user_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "supervisor_id", "forPendingOrAssignedTask")) {
            return this.engineClient.searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(this.getApiId(filters, "user_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "supervisor_id")) {
            return this.engineClient.searchProcessDefinitionsSupervisedBy(this.getApiId(filters, "supervisor_id"), searchOptions);
        }
        if (this.isFilteringOn(filters, "forPendingOrAssignedTask")) {
            return this.engineClient.searchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(searchOptions);
        }
        return this.engineClient.searchProcessDefinitions(searchOptions);
    }

    private boolean isFilteringOn(Map<String, String> filters, String ... attributes) {
        for (String attribute : attributes) {
            if (filters.containsKey(attribute)) continue;
            return false;
        }
        return true;
    }

    private Long getApiId(Map<String, String> filters, String attribute) {
        return APIID.makeAPIID(filters.get(attribute)).toLong();
    }

    private ItemSearchResult<ProcessItem> convertResult(int page, int nbResultsByPage, SearchResult<ProcessDeploymentInfo> result) {
        return new ItemSearchResultConverter<ProcessItem, ProcessDeploymentInfo>(page, nbResultsByPage, result, new ProcessItemConverter(this.engineClient.getProcessApi())).toItemSearchResult();
    }
}

