/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.filter;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.web.rest.server.datastore.converter.ValueConverter;
import org.bonitasoft.web.rest.server.framework.exception.APIFilterMandatoryException;

public class FilterAccessor {
    private final Map<String, String> filters;

    public FilterAccessor(Map<String, String> filters) {
        this.filters = filters;
    }

    public String getMandatory(String filter) {
        this.ensureFilterValue(filter);
        return this.getFilters().get(filter);
    }

    public <S extends Serializable> S getMandatory(String filter, ValueConverter<S> converter) {
        String value = this.getMandatory(filter);
        try {
            return converter.convert(value);
        }
        catch (Exception e) {
            throw new APIFilterMandatoryException(filter, (Throwable)e);
        }
    }

    private Map<String, String> getFilters() {
        return this.filters;
    }

    private void ensureFilterValue(String filter) {
        if (this.getFilters() == null || !this.getFilters().containsKey(filter)) {
            throw new APIFilterMandatoryException(filter);
        }
    }
}

