/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.GroupUpdater;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.identity.GroupItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.GroupCreatorConverter;
import org.bonitasoft.web.rest.server.datastore.organization.GroupItemConverter;
import org.bonitasoft.web.rest.server.datastore.organization.GroupUpdaterConverter;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.engineclient.GroupEngineClient;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class GroupDatastore
extends CommonDatastore<GroupItem, Group>
implements DatastoreHasAdd<GroupItem>,
DatastoreHasUpdate<GroupItem>,
DatastoreHasGet<GroupItem>,
DatastoreHasSearch<GroupItem>,
DatastoreHasDelete {
    public GroupDatastore(APISession engineSession) {
        super(engineSession);
    }

    public GroupEngineClient getGroupEngineClient() {
        return new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession())).createGroupEngineClient();
    }

    @Override
    public void delete(List<APIID> ids) {
        this.getGroupEngineClient().delete(APIID.toLongList(ids));
    }

    @Override
    public ItemSearchResult<GroupItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
            this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
            this.addStringFilterToSearchBuilder(filters, builder, "displayName", "displayName");
            this.addStringFilterToSearchBuilder(filters, builder, "parent_path", "parentPath");
            SearchResult engineSearchResults = TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).searchGroups(builder.done());
            return new ItemSearchResult<GroupItem>(page, resultsByPage, engineSearchResults.getCount(), new GroupItemConverter().convert(engineSearchResults.getResult()));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public GroupItem get(APIID id) {
        Group result = this.getGroupEngineClient().get(id.toLong());
        return new GroupItemConverter().convert(result);
    }

    @Override
    public GroupItem update(APIID id, Map<String, String> attributes) {
        GroupUpdater updater = new GroupUpdaterConverter(this.getGroupEngineClient()).convert(attributes);
        Group group = this.getGroupEngineClient().update(id.toLong(), updater);
        return new GroupItemConverter().convert(group);
    }

    @Override
    public GroupItem add(GroupItem group) {
        GroupCreator creator = new GroupCreatorConverter(this.getGroupEngineClient()).convert(group);
        Group result = this.getGroupEngineClient().create(creator);
        return new GroupItemConverter().convert(result);
    }

    public Long getNumberOfUsers(APIID groupId) {
        try {
            return TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession()).getNumberOfUsersInGroup(groupId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected GroupItem convertEngineToConsoleItem(Group group) {
        throw new RuntimeException("Unimplemented method");
    }
}

