/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.UserMembershipCriterion;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.identity.MembershipItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class MembershipDatastore
extends CommonDatastore<MembershipItem, UserMembership>
implements DatastoreHasAdd<MembershipItem>,
DatastoreHasSearch<MembershipItem>,
DatastoreHasDelete {
    public MembershipDatastore(APISession engineSession) {
        super(engineSession);
    }

    private IdentityAPI getIdentityAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession());
    }

    @Override
    protected MembershipItem convertEngineToConsoleItem(UserMembership item) {
        MembershipItem result = new MembershipItem();
        result.setUserId(item.getUserId());
        result.setRoleId(item.getRoleId());
        result.setGroupId(item.getGroupId());
        result.setAssignedByUserId(item.getAssignedBy());
        result.setAssignedDate(item.getAssignedDate());
        return result;
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.getIdentityAPI().deleteUserMembership(id.getPartAsLong(0).longValue(), id.getPartAsLong(1).longValue(), id.getPartAsLong(2).longValue());
            }
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<MembershipItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            Long userId = MapUtil.getValueAsLong(filters, "user_id");
            List engineItems = this.getIdentityAPI().getUserMemberships(userId.longValue(), SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, UserMembershipCriterion.valueOf((String)orders));
            List consoleSearchResults = this.convertEngineToConsoleItemsList(engineItems);
            long total = this.getIdentityAPI().getNumberOfUserMemberships(MapUtil.getValueAsLong(filters, "user_id").longValue());
            return new ItemSearchResult<MembershipItem>(page, resultsByPage, total, consoleSearchResults);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public MembershipItem add(MembershipItem item) {
        try {
            return this.convertEngineToConsoleItem(this.getIdentityAPI().addUserMembership(item.getUserId().toLong().longValue(), item.getGroupId().toLong().longValue(), item.getRoleId().toLong().longValue()));
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("This membership is already added to user"), (Throwable)e);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }
}

